/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.dataconversion;

import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.rest.dataconversion.JavaSerializationTranscoder;
import org.infinispan.test.data.Address;
import org.infinispan.test.data.Person;
import org.infinispan.test.dataconversion.AbstractTranscoderTest;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="rest.JavaSerializationTranscoderTest")
public class JavaSerializationTranscoderTest
extends AbstractTranscoderTest {
    protected Person dataSrc;

    @BeforeTest
    public void setUp() {
        this.dataSrc = new Person("Joe");
        Address address = new Address();
        address.setCity("London");
        this.dataSrc.setAddress(address);
        this.transcoder = new JavaSerializationTranscoder();
        this.supportedMediaTypes = this.transcoder.getSupportedMediaTypes();
    }

    public void testTranscoderTranscode() {
        MediaType personMediaType = MediaType.fromString((String)"application/x-java-object;type=org.infinispan.test.data.Person");
        Object result = this.transcoder.transcode((Object)this.dataSrc, personMediaType, MediaType.APPLICATION_SERIALIZED_OBJECT);
        Assert.assertTrue((boolean)(result instanceof byte[]), (String)"Must be byte[]");
        Object transcodedBack = this.transcoder.transcode(result, MediaType.APPLICATION_SERIALIZED_OBJECT, personMediaType);
        Assert.assertEquals((Object)transcodedBack, (Object)this.dataSrc, (String)"Must be an equal objects");
    }
}

