/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.profiling;

import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.ssl.OpenSsl;
import io.netty.util.CharsetUtil;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.util.StringContentProvider;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.infinispan.rest.http2.Http2Client;

public class BenchmarkHttpClient {
    private Http2Client http2Client;
    private HttpClient http1Client;
    private ExecutorCompletionService executorCompletionService;
    private String address;
    private int port;
    private boolean http2;
    private boolean usesTLS = false;
    private ExecutorService executor;

    public BenchmarkHttpClient(String keystorePath, String keystorePassword, String trustStorePath, String trustStorePassword) throws Exception {
        if (!OpenSsl.isAlpnSupported()) {
            throw new IllegalStateException("OpenSSL is not present, can not test TLS/ALPN support");
        }
        this.http2Client = Http2Client.newClientWithAlpn(keystorePath, keystorePassword);
        SslContextFactory sslContextFactory = new SslContextFactory();
        sslContextFactory.setTrustStorePassword(trustStorePath);
        sslContextFactory.setTrustStorePassword(trustStorePassword);
        sslContextFactory.setKeyStorePath(keystorePath);
        sslContextFactory.setKeyStorePassword(keystorePassword);
        this.http1Client = new HttpClient(sslContextFactory);
        this.usesTLS = true;
    }

    public BenchmarkHttpClient() {
        this.http2Client = Http2Client.newClientWithHttp11Upgrade();
        this.http1Client = new HttpClient();
    }

    public void performGets(int pertentageOfMisses, int numberOfGets, String existingKey, String nonExistingKey) throws Exception {
        int i;
        ThreadLocalRandom r = ThreadLocalRandom.current();
        for (i = 0; i < numberOfGets; ++i) {
            String key = ((Random)r).nextInt(100) < pertentageOfMisses ? nonExistingKey : existingKey;
            this.executorCompletionService.submit(() -> {
                if (this.http2) {
                    DefaultFullHttpRequest getRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/rest/default/" + key);
                    this.http2Client.sendRequest((FullHttpRequest)getRequest);
                } else {
                    try {
                        String scheme = this.usesTLS ? "https" : "http";
                        this.http1Client.GET(String.format("%s://localhost:%d/rest/%s/%s", scheme, this.port, "default", key));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                return 1;
            });
        }
        for (i = 0; i < numberOfGets; ++i) {
            this.executorCompletionService.take().get();
        }
        if (this.http2) {
            this.http2Client.awaitForResponses();
        }
    }

    public void performPuts(int numberOfInserts) throws Exception {
        int i;
        for (i = 0; i < numberOfInserts; ++i) {
            String randomKey = UUID.randomUUID().toString();
            this.executorCompletionService.submit(() -> {
                if (this.http2) {
                    DefaultFullHttpRequest putValueInCacheRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "/rest/default/" + randomKey, Unpooled.wrappedBuffer((byte[])"test".getBytes(CharsetUtil.UTF_8)));
                    this.http2Client.sendRequest((FullHttpRequest)putValueInCacheRequest);
                    return 1;
                }
                try {
                    String scheme = this.usesTLS ? "https" : "http";
                    this.http1Client.POST(String.format("%s://localhost:%d/rest/%s/%s", scheme, this.port, "default", "randomKey")).content((ContentProvider)new StringContentProvider("test")).send();
                    return 1;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        for (i = 0; i < numberOfInserts; ++i) {
            this.executorCompletionService.take().get();
        }
        if (this.http2) {
            this.http2Client.awaitForResponses();
        }
    }

    public void start(String address, int port, int threads, boolean http2) throws Exception {
        this.address = address;
        this.port = port;
        this.http2 = http2;
        if (http2) {
            this.http2Client.start(address, port);
        } else {
            this.http1Client.start();
        }
        this.executor = Executors.newFixedThreadPool(threads);
        this.executorCompletionService = new ExecutorCompletionService(this.executor);
    }

    public void stop() throws Exception {
        if (this.http2) {
            this.http2Client.stop();
        } else {
            this.http1Client.stop();
        }
        this.executor.shutdownNow();
    }
}

