/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.search;

import java.io.InputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.IntStream;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.util.StringContentProvider;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.dsl.IndexedQueryMode;
import org.infinispan.rest.assertion.ResponseAssertion;
import org.infinispan.rest.helper.RestServerHelper;
import org.infinispan.rest.search.IndexedRestSearchTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.fwk.TestResourceTracker;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public abstract class BaseRestSearchTest
extends MultipleCacheManagersTest {
    private static final String CACHE_NAME = "search-rest";
    private static final String PROTO_FILE_NAME = "person.proto";
    protected static final ObjectMapper MAPPER = new ObjectMapper();
    private HttpClient client;
    private List<RestServerHelper> restServers = new ArrayList<RestServerHelper>();
    private final Random random = new Random(1000L);

    protected int getNumNodes() {
        return 3;
    }

    protected void createCacheManagers() {
        ConfigurationBuilder builder = this.getConfigBuilder();
        this.createClusteredCaches(this.getNumNodes(), builder, true, new String[]{CACHE_NAME, "default"});
        this.waitForClusterToForm(CACHE_NAME);
    }

    @DataProvider(name="HttpMethodProvider")
    protected static Object[][] provideCacheMode() {
        return new Object[][]{{HttpMethod.GET}, {HttpMethod.POST}};
    }

    private RestServerHelper pickServer() {
        return this.restServers.get(this.random.nextInt(this.getNumNodes()));
    }

    private String getUrl(RestServerHelper restServerHelper) {
        return this.getUrl(restServerHelper, CACHE_NAME);
    }

    private String getUrl(RestServerHelper restServerHelper, String cacheName) {
        return String.format("http://localhost:%d/rest/%s?action=search", restServerHelper.getPort(), cacheName);
    }

    @BeforeClass
    public void setUp() throws Exception {
        IntStream.range(0, this.getNumNodes()).forEach(n -> {
            RestServerHelper restServer = new RestServerHelper((EmbeddedCacheManager)this.cacheManagers.get(n));
            restServer.start(TestResourceTracker.getCurrentTestShortName());
            this.restServers.add(restServer);
        });
        this.client = new HttpClient();
        this.client.start();
        String protoFile = Util.read((InputStream)IndexedRestSearchTest.class.getClassLoader().getResourceAsStream(PROTO_FILE_NAME));
        this.registerProtobuf(PROTO_FILE_NAME, protoFile);
        this.populateData();
    }

    @AfterMethod
    protected void clearContent() {
    }

    @Test(dataProvider="HttpMethodProvider")
    public void shouldReportInvalidQueries(HttpMethod method) throws Exception {
        String wrongQuery = "from Whatever";
        String searchUrl = this.getUrl(this.pickServer());
        ContentResponse response = method == HttpMethod.POST ? this.client.newRequest(searchUrl).method(HttpMethod.POST).content((ContentProvider)new StringContentProvider("{ \"query\": \"" + wrongQuery + "\"}")).send() : this.client.newRequest(searchUrl.concat("&query=").concat(URLEncoder.encode(wrongQuery, "UTF-8"))).method(HttpMethod.GET).send();
        Assert.assertEquals((int)response.getStatus(), (int)400);
        String contentAsString = response.getContentAsString();
        Assert.assertTrue((contentAsString.contains("Message descriptor not found") || contentAsString.contains("Unknown entity") ? 1 : 0) != 0);
    }

    @Test(dataProvider="HttpMethodProvider")
    public void shouldReturnEmptyResults(HttpMethod method) throws Exception {
        JsonNode query = this.query("from org.infinispan.rest.search.entity.Person p where p.name = 'nobody'", method);
        this.assertZeroHits(query);
    }

    @Test(dataProvider="HttpMethodProvider")
    public void testSimpleQuery(HttpMethod method) throws Exception {
        JsonNode queryResult = this.query("from org.infinispan.rest.search.entity.Person p where p.surname = 'Cage'", method);
        Assert.assertEquals((int)queryResult.get("total_results").getIntValue(), (int)1);
        ArrayNode hits = (ArrayNode)ArrayNode.class.cast(queryResult.get("hits"));
        Assert.assertEquals((int)hits.size(), (int)1);
        JsonNode result = (JsonNode)hits.iterator().next();
        JsonNode firstHit = result.get("hit");
        Assert.assertEquals((int)firstHit.get("id").getIntValue(), (int)2);
        Assert.assertEquals((String)firstHit.get("name").asText(), (String)"Luke");
        Assert.assertEquals((String)firstHit.get("surname").asText(), (String)"Cage");
    }

    @Test(dataProvider="HttpMethodProvider")
    public void testMultiResultQuery(HttpMethod method) throws Exception {
        JsonNode results = this.query("from org.infinispan.rest.search.entity.Person p where p.gender = 'MALE'", method);
        Assert.assertEquals((int)results.get("total_results").getIntValue(), (int)3);
        ArrayNode hits = (ArrayNode)ArrayNode.class.cast(results.get("hits"));
        Assert.assertEquals((int)hits.size(), (int)3);
    }

    @Test(dataProvider="HttpMethodProvider")
    public void testProjections(HttpMethod method) throws Exception {
        JsonNode results = this.query("Select name, surname from org.infinispan.rest.search.entity.Person", method);
        Assert.assertEquals((int)results.get("total_results").getIntValue(), (int)4);
        List names = results.findValues("name");
        List surnames = results.findValues("surname");
        List streets = results.findValues("street");
        List gender = results.findValues("gender");
        Assert.assertEquals((int)4, (int)names.size());
        Assert.assertEquals((int)4, (int)surnames.size());
        Assert.assertEquals((int)0, (int)streets.size());
        Assert.assertEquals((int)0, (int)gender.size());
    }

    @Test(dataProvider="HttpMethodProvider")
    public void testGrouping(HttpMethod method) throws Exception {
        JsonNode results = this.query("select p.gender, count(p.name) from org.infinispan.rest.search.entity.Person p group by p.gender order by p.gender", method);
        Assert.assertEquals((int)results.get("total_results").getIntValue(), (int)2);
        ArrayNode hits = (ArrayNode)ArrayNode.class.cast(results.get("hits"));
        JsonNode males = hits.get(0);
        Assert.assertEquals((int)males.path("hit").path("name").getIntValue(), (int)3);
        JsonNode females = hits.get(1);
        Assert.assertEquals((int)females.path("hit").path("name").getIntValue(), (int)1);
    }

    @Test(dataProvider="HttpMethodProvider")
    public void testOffSet(HttpMethod method) throws Exception {
        String q = "select p.name from org.infinispan.rest.search.entity.Person p order by p.name desc";
        JsonNode results = this.query(q, method, 2, 2, CACHE_NAME);
        Assert.assertEquals((int)results.get("total_results").getIntValue(), (int)4);
        ArrayNode hits = (ArrayNode)ArrayNode.class.cast(results.get("hits"));
        Assert.assertEquals((int)hits.size(), (int)2);
        Assert.assertEquals((String)hits.get(0).path("hit").path("name").asText(), (String)"Jessica");
        Assert.assertEquals((String)hits.get(1).path("hit").path("name").asText(), (String)"Danny");
    }

    @Test(dataProvider="HttpMethodProvider")
    public void testIncompleteSearch(HttpMethod method) throws Exception {
        String searchUrl = this.getUrl(this.pickServer());
        ContentResponse response = this.client.newRequest(searchUrl).method(method).send();
        ResponseAssertion.assertThat(response).isBadRequest();
        String contentAsString = response.getContentAsString();
        JsonNode jsonNode = MAPPER.readTree(contentAsString);
        Assert.assertTrue((boolean)jsonNode.get("error").path("message").asText().contains("Invalid search request"));
    }

    @Test
    public void testReadDocument() throws Exception {
        ContentResponse response = this.get("1", "*/*");
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).bodyNotEmpty();
    }

    @Test
    public void testReadDocumentFromBrowser() throws Exception {
        ContentResponse fromBrowser = this.get("2", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        ResponseAssertion.assertThat(fromBrowser).isOk();
        ResponseAssertion.assertThat(fromBrowser).bodyNotEmpty();
        ResponseAssertion.assertThat(fromBrowser).hasContentType("application/json");
        JsonNode person = MAPPER.readTree(fromBrowser.getContentAsString());
        Assert.assertEquals((int)person.get("id").getIntValue(), (int)2);
    }

    @AfterClass
    public void tearDown() throws Exception {
        this.client.stop();
        this.restServers.forEach(RestServerHelper::stop);
    }

    protected void populateData() throws Exception {
        ObjectNode person1 = this.createPerson(1, "Jessica", "Jones", "46th St", "NY 10036", "FEMALE", 1111, 2222, 3333);
        ObjectNode person2 = this.createPerson(2, "Luke", "Cage", "Malcolm X Boulevard", "NY 11221", "MALE", 4444, 5555);
        ObjectNode person3 = this.createPerson(3, "Matthew", "Murdock", "57th St", "NY 10019", "MALE", new int[0]);
        ObjectNode person4 = this.createPerson(4, "Danny", "Randy", "Vanderbilt Av.", "NY 10017", "MALE", 2122561084);
        this.index(1, person1.toString());
        this.index(2, person2.toString());
        this.index(3, person3.toString());
        this.index(4, person4.toString());
    }

    private void index(int id, String person) throws Exception {
        this.write(id, person, HttpMethod.POST, MediaType.APPLICATION_JSON);
    }

    protected void put(int id, String contents) throws Exception {
        this.write(id, contents, HttpMethod.PUT, MediaType.APPLICATION_JSON);
    }

    protected void write(int id, String contents, HttpMethod method, MediaType contentType) throws Exception {
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%d", this.pickServer().getPort(), CACHE_NAME, id)).method(method).content((ContentProvider)new StringContentProvider(contents)).header(HttpHeader.CONTENT_TYPE, contentType.toString()).send();
        Assert.assertEquals((int)response.getStatus(), (int)200);
    }

    protected ContentResponse get(String id, String accept) throws Exception {
        return this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.pickServer().getPort(), CACHE_NAME, id)).header(HttpHeader.ACCEPT, accept).send();
    }

    protected ObjectNode createPerson(int id, String name, String surname, String street, String postCode, String gender, int ... phoneNumbers) {
        ObjectNode person = MAPPER.createObjectNode();
        person.put("_type", "org.infinispan.rest.search.entity.Person");
        person.put("id", id);
        person.put("name", name);
        person.put("surname", surname);
        person.put("gender", gender);
        ObjectNode address = person.putObject("address");
        if (this.needType()) {
            address.put("_type", "org.infinispan.rest.search.entity.Address");
        }
        address.put("street", street);
        address.put("postCode", postCode);
        ArrayNode numbers = person.putArray("phoneNumbers");
        for (int phone : phoneNumbers) {
            ObjectNode number = numbers.addObject();
            if (this.needType()) {
                number.put("_type", "org.infinispan.rest.search.entity.PhoneNumber");
            }
            number.put("number", phone);
        }
        return person;
    }

    protected void registerProtobuf(String protoFileName, String protoFileContents) throws Exception {
        String protobufMetadataUrl = this.getProtobufMetadataUrl(protoFileName);
        ContentResponse response = this.client.newRequest(protobufMetadataUrl).content((ContentProvider)new StringContentProvider(protoFileContents)).method(HttpMethod.POST).send();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String errorKey = protoFileName.concat(".error");
        ContentResponse errorCheck = this.client.newRequest(this.getProtobufMetadataUrl(errorKey)).method(HttpMethod.GET).send();
        Assert.assertEquals((int)errorCheck.getStatus(), (int)404);
    }

    private String getProtobufMetadataUrl(String key) {
        return String.format("http://localhost:%d/rest/%s/%s", this.pickServer().getPort(), "___protobuf_metadata", key);
    }

    private void assertZeroHits(JsonNode queryResponse) {
        ArrayNode hits = (ArrayNode)ArrayNode.class.cast(queryResponse.get("hits"));
        Assert.assertEquals((int)hits.size(), (int)0);
    }

    private JsonNode query(String q, HttpMethod method) throws Exception {
        return this.query(q, method, 0, 10, CACHE_NAME);
    }

    private JsonNode query(String q, HttpMethod method, int offset, int maxResults, String cacheName) throws Exception {
        Request request;
        Object queryReq;
        String searchUrl = this.getUrl(this.pickServer(), cacheName);
        String mode = this.getQueryMode().toString();
        if (method == HttpMethod.POST) {
            queryReq = MAPPER.createObjectNode();
            queryReq.put("query", q);
            queryReq.put("offset", offset);
            queryReq.put("max_results", maxResults);
            queryReq.put("query_mode", mode);
            request = this.client.newRequest(searchUrl).method(HttpMethod.POST).content((ContentProvider)new StringContentProvider(queryReq.toString()));
        } else {
            queryReq = new StringBuilder(searchUrl);
            ((StringBuilder)queryReq).append("&query=").append(URLEncoder.encode(q, "UTF-8"));
            ((StringBuilder)queryReq).append("&offset=").append(offset);
            ((StringBuilder)queryReq).append("&max_results=").append(maxResults);
            ((StringBuilder)queryReq).append("&").append("query_mode").append("=").append(mode);
            request = this.client.newRequest(((StringBuilder)queryReq).toString()).method(HttpMethod.GET);
        }
        ContentResponse response = request.send();
        String contentAsString = response.getContentAsString();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        return MAPPER.readTree(contentAsString);
    }

    protected boolean needType() {
        return false;
    }

    abstract ConfigurationBuilder getConfigBuilder();

    IndexedQueryMode getQueryMode() {
        return IndexedQueryMode.FETCH;
    }
}

