/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.dataconversion;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.XStreamException;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.OneToManyTranscoder;
import org.infinispan.commons.dataconversion.StandardConversions;
import org.infinispan.rest.logging.Log;
import org.infinispan.rest.operations.mediatypes.impl.JSONOutputPrinter;
import org.infinispan.util.logging.LogFactory;

public class XMLTranscoder
extends OneToManyTranscoder {
    protected static final Log logger = (Log)LogFactory.getLog(JSONOutputPrinter.class, Log.class);

    public XMLTranscoder() {
        super(MediaType.APPLICATION_XML, new MediaType[]{MediaType.APPLICATION_OBJECT, MediaType.APPLICATION_OCTET_STREAM, MediaType.TEXT_PLAIN});
    }

    public Object transcode(Object content, MediaType contentType, MediaType destinationType) {
        if (destinationType.match(MediaType.APPLICATION_XML)) {
            if (contentType.match(MediaType.APPLICATION_OBJECT)) {
                Object decoded = StandardConversions.decodeObjectContent((Object)content, (MediaType)contentType);
                return XStreamHolder.XStream.toXML(decoded);
            }
            if (contentType.match(MediaType.TEXT_PLAIN)) {
                return StandardConversions.convertCharset((Object)content, (Charset)contentType.getCharset(), (Charset)destinationType.getCharset());
            }
            if (contentType.match(MediaType.APPLICATION_OCTET_STREAM)) {
                byte[] bytes = StandardConversions.decodeOctetStream((Object)content, (MediaType)destinationType);
                return XStreamHolder.XStream.toXML((Object)bytes);
            }
        } else {
            try {
                Reader xmlReader = content instanceof byte[] ? new InputStreamReader(new ByteArrayInputStream((byte[])content)) : new StringReader(content.toString());
                return XStreamHolder.XStream.fromXML(xmlReader);
            }
            catch (XStreamException e) {
                throw logger.errorTranscoding(e);
            }
        }
        throw logger.unsupportedDataFormat(contentType.toString());
    }

    private static class XStreamHolder {
        static final XStream XStream = new XStream();

        private XStreamHolder() {
        }
    }
}

