/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import java.util.Map;
import org.assertj.core.api.Assertions;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.dataconversion.IdentityEncoder;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.rest.BaseRestOperationsTest;
import org.infinispan.rest.TestClass;
import org.infinispan.rest.assertion.ResponseAssertion;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="rest.RestOperationsTest")
public class RestOperationsTest
extends BaseRestOperationsTest {
    @Override
    public ConfigurationBuilder getDefaultCacheBuilder() {
        return new ConfigurationBuilder();
    }

    @Override
    protected boolean enableCompatibility() {
        return true;
    }

    @Override
    protected void defineCaches() {
        super.defineCaches();
        ConfigurationBuilder object = this.getDefaultCacheBuilder();
        object.encoding().key().mediaType("text/plain");
        object.encoding().value().mediaType("application/x-java-object");
        ConfigurationBuilder legacyStorageCache = this.getDefaultCacheBuilder();
        legacyStorageCache.encoding().key().mediaType("application/x-java-object;type=java.lang.String");
        this.restServer.defineCache("objectCache", object);
        this.restServer.defineCache("legacy", legacyStorageCache);
    }

    @Test
    public void shouldReadWriteToLegacyCache() throws Exception {
        this.putStringValueInCache("legacy", "test", "test");
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "legacy", "test")).header(HttpHeader.ACCEPT, "text/plain").send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("text/plain");
        ResponseAssertion.assertThat(response).hasReturnedText("test");
    }

    @Test
    public void shouldConvertExistingSerializableObjectToJson() throws Exception {
        TestClass testClass = new TestClass();
        testClass.setName("test");
        this.putValueInCache("objectCache", "test".getBytes(), testClass);
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "objectCache", "test")).header(HttpHeader.ACCEPT, "application/json").send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("application/json");
        ResponseAssertion.assertThat(response).hasReturnedText("{\"_type\":\"" + TestClass.class.getName() + "\",\"name\":\"test\"}");
    }

    @Test
    public void shouldConvertExistingSerializableObjectToXml() throws Exception {
        TestClass testClass = new TestClass();
        testClass.setName("test");
        this.putValueInCache("objectCache", "test".getBytes(), testClass);
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "objectCache", "test")).header(HttpHeader.ACCEPT, "application/xml").send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("application/xml");
        ResponseAssertion.assertThat(response).hasReturnedText("<org.infinispan.rest.TestClass>\n  <name>test</name>\n</org.infinispan.rest.TestClass>");
    }

    @Test
    public void shouldReadAsBinaryWithCompatMode() throws Exception {
        String cacheName = "compatCache";
        String key = "test";
        TestClass value = new TestClass();
        value.setName("test");
        this.putValueInCache(cacheName, key, value);
        ContentResponse response = this.get(cacheName, key, "application/octet-stream");
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("application/octet-stream");
    }

    @Test
    public void shouldReadTextWithCompatMode() throws Exception {
        String cacheName = "compatCache";
        String key = "k1";
        String value = "v1";
        this.putValueInCache(cacheName, key, value);
        ContentResponse response = this.get(cacheName, key, "text/plain");
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("text/plain");
        ResponseAssertion.assertThat(response).hasReturnedText(value);
    }

    @Test
    public void shouldReadByteArrayWithCompatMode() throws Exception {
        AdvancedCache cache = this.restServer.getCacheManager().getCache("compatCache").getAdvancedCache().withEncoding(IdentityEncoder.class);
        cache.put((Object)"k1", (Object)"v1".getBytes());
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "compatCache", "k1")).header(HttpHeader.ACCEPT, "application/octet-stream").send();
        ResponseAssertion.assertThat(response).hasReturnedBytes("v1".getBytes());
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("application/octet-stream");
    }

    @Test
    public void shouldReadAsJsonWithCompatMode() throws Exception {
        TestClass testClass = new TestClass();
        testClass.setName("test");
        this.putValueInCache("compatCache", "test", testClass);
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "compatCache", "test")).header(HttpHeader.ACCEPT, "application/json").send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("application/json");
        ResponseAssertion.assertThat(response).hasReturnedText("{\"_type\":\"org.infinispan.rest.TestClass\",\"name\":\"test\"}");
    }

    @Test
    public void shouldNegotiateFromCompatCacheWithoutAccept() throws Exception {
        TestClass testClass = new TestClass();
        testClass.setName("test");
        String cacheName = "compatCache";
        String key = "k1";
        this.putValueInCache(cacheName, key, testClass);
        ContentResponse response = this.get(cacheName, key, null);
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("text/plain");
        ResponseAssertion.assertThat(response).hasReturnedText(testClass.toString());
    }

    @Test
    public void shouldWriteTextContentWithCompatMode() throws Exception {
        this.putStringValueInCache("compatCache", "key1", "data");
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "compatCache", "key1")).header(HttpHeader.ACCEPT, "text/plain").send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasReturnedText("data");
        ResponseAssertion.assertThat(response).hasContentType("text/plain");
    }

    @Test
    public void shouldWriteOctetStreamToDefaultCache() throws Exception {
        this.putBinaryValueInCache("default", "keyA", "<hey>ho</hey>".getBytes(), MediaType.APPLICATION_OCTET_STREAM);
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "default", "keyA")).send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasReturnedBytes("<hey>ho</hey>".getBytes());
        ResponseAssertion.assertThat(response).hasContentType("application/octet-stream");
    }

    @Test
    public void shouldIgnoreDisabledCaches() throws Exception {
        this.putStringValueInCache("default", "K", "V");
        String url = String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "default", "K");
        ContentResponse response = this.client.newRequest(url).send();
        ResponseAssertion.assertThat(response).isOk();
        this.restServer.ignoreCache("default");
        response = this.client.newRequest(url).send();
        ResponseAssertion.assertThat(response).isServiceUnavailable();
        this.restServer.unignoreCache("default");
        response = this.client.newRequest(url).send();
        ResponseAssertion.assertThat(response).isOk();
    }

    @Test
    public void shouldDeleteExistingValueEvenWithoutMetadata() throws Exception {
        this.putValueInCache("default", "test".getBytes(), "test");
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "default", "test")).method(HttpMethod.DELETE).send();
        ResponseAssertion.assertThat(response).isOk();
        Assertions.assertThat((Map)this.restServer.getCacheManager().getCache("default")).isEmpty();
    }
}

