/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.search;

import org.codehaus.jackson.JsonNode;
import org.eclipse.jetty.client.api.ContentResponse;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.query.indexmanager.InfinispanIndexManager;
import org.infinispan.rest.search.BaseRestSearchTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="rest.IndexedRestSearchTest")
public class IndexedRestSearchTest
extends BaseRestSearchTest {
    @Override
    ConfigurationBuilder getConfigBuilder() {
        ConfigurationBuilder configurationBuilder = IndexedRestSearchTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC);
        configurationBuilder.indexing().index(Index.PRIMARY_OWNER).addProperty("default.indexmanager", InfinispanIndexManager.class.getName());
        return configurationBuilder;
    }

    @Test
    public void testReplaceIndexedDocument() throws Exception {
        this.put(10, this.createPerson(0, "P", "", "?", "?", "MALE", new int[0]).toString());
        this.put(10, this.createPerson(0, "P", "Surname", "?", "?", "MALE", new int[0]).toString());
        ContentResponse response = this.get("10", "application/json");
        JsonNode person = MAPPER.readTree(response.getContentAsString());
        Assert.assertEquals((String)"Surname", (String)person.get("surname").asText());
    }
}

