/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.logging;

import org.infinispan.commons.dataconversion.EncodingException;
import org.infinispan.rest.cachemanager.exceptions.CacheUnavailableException;
import org.infinispan.rest.operations.exceptions.NoCacheFoundException;
import org.infinispan.rest.operations.exceptions.ServiceUnavailableException;
import org.infinispan.rest.operations.exceptions.UnacceptableDataFormatException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="ISPN")
public interface Log
extends BasicLogger {
    @Message(value="Error transcoding content", id=495)
    public EncodingException errorTranscoding(@Cause Throwable var1);

    @Message(value="Unsupported configuration option", id=12004)
    public UnsupportedOperationException unsupportedConfigurationOption();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="An error occurred while responding to the client", id=12005)
    public void errorWhileResponding(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Uncaught exception in the pipeline", id=12006)
    public void uncaughtExceptionInThePipeline(@Cause Throwable var1);

    @Message(value="Cannot convert to %s", id=12007)
    public UnacceptableDataFormatException unsupportedDataFormat(String var1);

    @Message(value="Cache with name '%s' is temporarily unavailable.", id=12008)
    public ServiceUnavailableException cacheUnavailable(String var1);

    @Message(value="Cannot obtain cache '%s', without required MediaType", id=12009)
    public NullPointerException missingRequiredMediaType(String var1);

    @Message(value="Cache with name '%s' not found amongst the configured caches", id=12010)
    public NoCacheFoundException cacheNotFound(String var1);

    @Message(value="Remote requests are not allowed to private caches. Do no send remote requests to cache '%s'", id=12011)
    public CacheUnavailableException requestNotAllowedToInternalCaches(String var1);

    @Message(value="Remote requests are not allowed to internal caches when authorization is disabled. Do no send remote requests to cache '%s'", id=12012)
    public CacheUnavailableException requestNotAllowedToInternalCachesWithoutAuthz(String var1);

    @Message(value="Content cannot be converted to XML", id=12013)
    public UnacceptableDataFormatException cannotConvertToXML(@Cause Throwable var1);
}

