/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.search;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.codehaus.jackson.map.ObjectMapper;
import org.infinispan.query.dsl.IndexedQueryMode;
import org.infinispan.rest.InfinispanRequest;
import org.infinispan.rest.operations.SearchOperations;
import org.infinispan.rest.operations.exceptions.NoCacheFoundException;
import org.infinispan.rest.operations.exceptions.NoDataFoundException;
import org.infinispan.rest.search.InfinispanSearchResponse;
import org.infinispan.rest.search.QueryRequest;

public class InfinispanSearchRequest
extends InfinispanRequest {
    private final ObjectMapper mapper = new ObjectMapper();
    private final SearchOperations searchOperations;

    public InfinispanSearchRequest(SearchOperations searchOperations, FullHttpRequest request, ChannelHandlerContext ctx, String cacheName, String context, Map<String, List<String>> parameters) {
        super(request, ctx, cacheName, context, parameters);
        this.searchOperations = searchOperations;
    }

    @Override
    protected InfinispanSearchResponse execute() {
        Optional<String> cacheName = this.getCacheName();
        if (!cacheName.isPresent()) {
            throw new NoCacheFoundException("Cache name must be provided");
        }
        try {
            QueryRequest queryRequest = this.getQueryRequest();
            String queryString = queryRequest.getQuery();
            if (queryString == null || queryString.isEmpty()) {
                return InfinispanSearchResponse.badRequest(this, "Invalid search request, missing 'query' parameter", null);
            }
            return this.searchOperations.search(cacheName.get(), queryRequest, this);
        }
        catch (IOException e) {
            return InfinispanSearchResponse.badRequest(this, "Invalid search request", e.getMessage());
        }
    }

    private QueryRequest getQueryRequest() throws IOException {
        QueryRequest queryRequest = null;
        if (this.request.method() == HttpMethod.GET) {
            queryRequest = this.getQueryFromString();
        } else if (this.request.method() == HttpMethod.POST || this.request.method() == HttpMethod.PUT) {
            queryRequest = this.getQueryFromJSON();
        }
        return queryRequest;
    }

    private QueryRequest getQueryFromString() {
        String queryString = this.getParameterValue("query");
        String strOffset = this.getParameterValue("offset");
        String queryMode = this.getParameterValue("query_mode");
        String strMaxResults = this.getParameterValue("max_results");
        Integer offset = strOffset != null ? Integer.valueOf(strOffset) : null;
        Integer maxResults = strMaxResults != null ? Integer.valueOf(strMaxResults) : null;
        IndexedQueryMode qm = queryMode == null ? IndexedQueryMode.FETCH : IndexedQueryMode.valueOf((String)queryMode);
        return new QueryRequest(queryString, offset, maxResults, qm);
    }

    private QueryRequest getQueryFromJSON() throws IOException {
        byte[] data = this.data().orElseThrow(NoDataFoundException::new);
        return (QueryRequest)this.mapper.readValue(data, QueryRequest.class);
    }
}

