/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.logging;

import java.io.Serializable;
import java.util.Arrays;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.dataconversion.EncodingException;
import org.infinispan.rest.cachemanager.exceptions.CacheUnavailableException;
import org.infinispan.rest.logging.Log;
import org.infinispan.rest.operations.exceptions.NoCacheFoundException;
import org.infinispan.rest.operations.exceptions.ServiceUnavailableException;
import org.infinispan.rest.operations.exceptions.UnacceptableDataFormatException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class Log_$logger
extends DelegatingBasicLogger
implements Serializable,
Log,
BasicLogger {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    private static final String errorTranscoding = "ISPN000495: Error transcoding content";
    private static final String unsupportedConfigurationOption = "ISPN012004: Unsupported configuration option";
    private static final String errorWhileResponding = "ISPN012005: An error occurred while responding to the client";
    private static final String uncaughtExceptionInThePipeline = "ISPN012006: Uncaught exception in the pipeline";
    private static final String unsupportedDataFormat = "ISPN012007: Cannot convert to %s";
    private static final String cacheUnavailable = "ISPN012008: Cache with name '%s' is temporarily unavailable.";
    private static final String missingRequiredMediaType = "ISPN012009: Cannot obtain cache '%s', without required MediaType";
    private static final String cacheNotFound = "ISPN012010: Cache with name '%s' not found amongst the configured caches";
    private static final String requestNotAllowedToInternalCaches = "ISPN012011: Remote requests are not allowed to private caches. Do no send remote requests to cache '%s'";
    private static final String requestNotAllowedToInternalCachesWithoutAuthz = "ISPN012012: Remote requests are not allowed to internal caches when authorization is disabled. Do no send remote requests to cache '%s'";
    private static final String cannotConvertToXML = "ISPN012013: Content cannot be converted to XML";
    private static final String illegalCompressionLevel = "ISPN012014: Illegal compression level '%d'. The value must be >= 0 and <= 9";

    public Log_$logger(Logger log) {
        super(log);
    }

    @Override
    public final EncodingException errorTranscoding(Throwable cause) {
        EncodingException result = new EncodingException(String.format(this.errorTranscoding$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorTranscoding$str() {
        return errorTranscoding;
    }

    @Override
    public final UnsupportedOperationException unsupportedConfigurationOption() {
        UnsupportedOperationException result = new UnsupportedOperationException(String.format(this.unsupportedConfigurationOption$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupportedConfigurationOption$str() {
        return unsupportedConfigurationOption;
    }

    @Override
    public final void errorWhileResponding(Exception e) {
        this.log.logf(FQCN, Logger.Level.TRACE, (Throwable)e, this.errorWhileResponding$str(), new Object[0]);
    }

    protected String errorWhileResponding$str() {
        return errorWhileResponding;
    }

    @Override
    public final void uncaughtExceptionInThePipeline(Throwable e) {
        this.log.logf(FQCN, Logger.Level.ERROR, e, this.uncaughtExceptionInThePipeline$str(), new Object[0]);
    }

    protected String uncaughtExceptionInThePipeline$str() {
        return uncaughtExceptionInThePipeline;
    }

    @Override
    public final UnacceptableDataFormatException unsupportedDataFormat(String mediaType) {
        UnacceptableDataFormatException result = new UnacceptableDataFormatException(String.format(this.unsupportedDataFormat$str(), mediaType));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupportedDataFormat$str() {
        return unsupportedDataFormat;
    }

    @Override
    public final ServiceUnavailableException cacheUnavailable(String cacheName) {
        ServiceUnavailableException result = new ServiceUnavailableException(String.format(this.cacheUnavailable$str(), cacheName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cacheUnavailable$str() {
        return cacheUnavailable;
    }

    @Override
    public final NullPointerException missingRequiredMediaType(String cacheName) {
        NullPointerException result = new NullPointerException(String.format(this.missingRequiredMediaType$str(), cacheName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String missingRequiredMediaType$str() {
        return missingRequiredMediaType;
    }

    @Override
    public final NoCacheFoundException cacheNotFound(String cacheName) {
        NoCacheFoundException result = new NoCacheFoundException(String.format(this.cacheNotFound$str(), cacheName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cacheNotFound$str() {
        return cacheNotFound;
    }

    @Override
    public final CacheUnavailableException requestNotAllowedToInternalCaches(String cacheName) {
        CacheUnavailableException result = new CacheUnavailableException(String.format(this.requestNotAllowedToInternalCaches$str(), cacheName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String requestNotAllowedToInternalCaches$str() {
        return requestNotAllowedToInternalCaches;
    }

    @Override
    public final CacheUnavailableException requestNotAllowedToInternalCachesWithoutAuthz(String cacheName) {
        CacheUnavailableException result = new CacheUnavailableException(String.format(this.requestNotAllowedToInternalCachesWithoutAuthz$str(), cacheName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String requestNotAllowedToInternalCachesWithoutAuthz$str() {
        return requestNotAllowedToInternalCachesWithoutAuthz;
    }

    @Override
    public final UnacceptableDataFormatException cannotConvertToXML(Throwable e) {
        UnacceptableDataFormatException result = new UnacceptableDataFormatException(String.format(this.cannotConvertToXML$str(), new Object[0]));
        result.initCause(e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotConvertToXML$str() {
        return cannotConvertToXML;
    }

    @Override
    public final CacheConfigurationException illegalCompressionLevel(int compressionLevel) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.illegalCompressionLevel$str(), compressionLevel));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String illegalCompressionLevel$str() {
        return illegalCompressionLevel;
    }
}

