/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.dataconversion;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Optional;
import org.codehaus.jackson.annotate.JsonTypeInfo;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.jsontype.TypeResolverBuilder;
import org.codehaus.jackson.type.JavaType;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.OneToManyTranscoder;
import org.infinispan.commons.dataconversion.StandardConversions;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class JsonTranscoder
extends OneToManyTranscoder {
    protected static final Log logger = (Log)LogFactory.getLog(JsonTranscoder.class, Log.class);
    private final ObjectMapper jsonMapper = new ObjectMapper().setDefaultTyping((TypeResolverBuilder)new ObjectMapper.DefaultTypeResolverBuilder(ObjectMapper.DefaultTyping.NON_FINAL){
        {
            this.init(JsonTypeInfo.Id.CLASS, null);
            this.inclusion(JsonTypeInfo.As.PROPERTY);
            this.typeProperty("_type");
        }

        public boolean useForType(JavaType t) {
            return !t.isContainerType() && super.useForType(t);
        }
    });

    public JsonTranscoder() {
        super(MediaType.APPLICATION_JSON, new MediaType[]{MediaType.APPLICATION_OBJECT, MediaType.APPLICATION_OCTET_STREAM, MediaType.TEXT_PLAIN});
    }

    public Object transcode(Object content, MediaType contentType, MediaType destinationType) {
        if (destinationType.match(MediaType.APPLICATION_OCTET_STREAM)) {
            return StandardConversions.convertTextToOctetStream((Object)content, (MediaType)contentType);
        }
        if (destinationType.match(MediaType.APPLICATION_JSON)) {
            if (contentType.match(MediaType.APPLICATION_JSON)) {
                Charset destinationCharset;
                Charset sourceCharset = contentType.getCharset();
                if (!sourceCharset.equals(destinationCharset = destinationType.getCharset())) {
                    return StandardConversions.convertCharset((Object)content, (Charset)sourceCharset, (Charset)destinationCharset);
                }
                return content;
            }
            try {
                if (content instanceof byte[]) {
                    String contentAsString = new String((byte[])content, destinationType.getCharset());
                    return this.jsonMapper.writeValueAsString((Object)contentAsString);
                }
                return this.jsonMapper.writeValueAsString(content);
            }
            catch (IOException e) {
                throw new CacheException((Throwable)e);
            }
        }
        if (destinationType.match(MediaType.APPLICATION_OBJECT)) {
            try {
                if (content instanceof byte[]) {
                    return this.jsonMapper.readValue((byte[])content, Object.class);
                }
                return this.jsonMapper.readValue((String)content, Object.class);
            }
            catch (IOException e) {
                throw new CacheException((Throwable)e);
            }
        }
        if (destinationType.match(MediaType.TEXT_PLAIN)) {
            Optional optDestinationCharset = destinationType.getParameter("charset");
            if (!optDestinationCharset.isPresent()) {
                return content;
            }
            if (content instanceof byte[]) {
                Charset sourceCharset = contentType.getParameter("charset").map(Charset::forName).orElse(Charset.defaultCharset());
                Charset destinationCharset = Charset.forName((String)optDestinationCharset.get());
                byte[] byteContent = (byte[])content;
                return StandardConversions.convertCharset((Object)byteContent, (Charset)sourceCharset, (Charset)destinationCharset);
            }
        }
        throw logger.unsupportedContent(content);
    }
}

