/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.util.ByteBufferContentProvider;
import org.eclipse.jetty.client.util.BytesContentProvider;
import org.eclipse.jetty.client.util.StringContentProvider;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.dataconversion.IdentityEncoder;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.StandardConversions;
import org.infinispan.commons.marshall.JavaSerializationMarshaller;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.metadata.Metadata;
import org.infinispan.rest.TestClass;
import org.infinispan.rest.assertion.ResponseAssertion;
import org.infinispan.rest.helper.RestServerHelper;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.fwk.TestResourceTracker;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public abstract class BaseRestOperationsTest
extends AbstractInfinispanTest {
    protected HttpClient client;
    protected RestServerHelper restServer;
    private static final long DEFAULT_LIFESPAN = 45190L;
    private static final long DEFAULT_MAX_IDLE = 1859446L;

    protected abstract ConfigurationBuilder getDefaultCacheBuilder();

    protected abstract boolean enableCompatibility();

    @BeforeClass
    public void beforeSuite() throws Exception {
        this.restServer = RestServerHelper.defaultRestServer(this.getDefaultCacheBuilder(), "default");
        this.defineCaches();
        this.restServer.start(TestResourceTracker.getCurrentTestShortName());
        this.client = new HttpClient();
        this.client.start();
    }

    protected void defineCaches() {
        ConfigurationBuilder expirationConfiguration = this.getDefaultCacheBuilder();
        expirationConfiguration.expiration().lifespan(45190L).maxIdle(1859446L);
        ConfigurationBuilder xmlCacheConfiguration = this.getDefaultCacheBuilder();
        xmlCacheConfiguration.encoding().value().mediaType("application/xml");
        ConfigurationBuilder jsonCacheConfiguration = this.getDefaultCacheBuilder();
        jsonCacheConfiguration.encoding().value().mediaType("application/json");
        ConfigurationBuilder octetStreamCacheConfiguration = this.getDefaultCacheBuilder();
        octetStreamCacheConfiguration.encoding().value().mediaType("application/octet-stream");
        ConfigurationBuilder unknownContentCacheConfiguration = this.getDefaultCacheBuilder();
        unknownContentCacheConfiguration.encoding().value().mediaType("application/unknown");
        ConfigurationBuilder javaSerialized = this.getDefaultCacheBuilder();
        javaSerialized.encoding().value().mediaType("application/x-java-serialized-object");
        ConfigurationBuilder text = this.getDefaultCacheBuilder();
        text.encoding().key().mediaType("text/plain");
        text.encoding().value().mediaType("text/plain");
        ConfigurationBuilder compat = this.getDefaultCacheBuilder();
        compat.compatibility().enabled(this.enableCompatibility());
        this.restServer.defineCache("expiration", expirationConfiguration);
        this.restServer.defineCache("xml", xmlCacheConfiguration);
        this.restServer.defineCache("json", jsonCacheConfiguration);
        this.restServer.defineCache("binary", octetStreamCacheConfiguration);
        this.restServer.defineCache("unknown", unknownContentCacheConfiguration);
        this.restServer.defineCache("serialized", javaSerialized);
        this.restServer.defineCache("textCache", text);
        this.restServer.defineCache("compatCache", compat);
    }

    @AfterClass
    public void afterSuite() throws Exception {
        this.client.stop();
        this.restServer.stop();
    }

    @AfterMethod
    public void afterMethod() {
        this.restServer.clear();
    }

    public InternalCacheEntry<String, byte[]> getCacheEntry(String cacheName, byte[] key) {
        CacheEntry cacheEntry = this.getCache(cacheName).getCacheEntry((Object)key);
        return (InternalCacheEntry)cacheEntry;
    }

    public AdvancedCache getCache(String cacheName) {
        return this.restServer.getCacheManager().getCache(cacheName, false).getAdvancedCache().withKeyEncoding(IdentityEncoder.class);
    }

    @Test
    public void shouldGetNonExistingValue() throws Exception {
        ContentResponse response = this.client.GET("http://localhost:" + this.restServer.getPort() + "/rest/default/nonExisting");
        ResponseAssertion.assertThat(response).doesntExist();
    }

    @Test
    public void shouldReturnNotExistingOnWrongContext() throws Exception {
        this.putStringValueInCache("default", "test", "test");
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/wrongContext/%s/%s", this.restServer.getPort(), "default", "test")).header(HttpHeader.ACCEPT, "text/plain").send();
        ResponseAssertion.assertThat(response).doesntExist();
    }

    @Test
    public void shouldGetAsciiValueStoredInSpecificFormat() throws Exception {
        this.putStringValueInCache("default", "test", "test");
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "default", "test")).header(HttpHeader.ACCEPT, "text/plain").send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("text/plain");
        ResponseAssertion.assertThat(response).hasReturnedText("test");
    }

    @Test
    public void shouldHaveProperEtagWhenGettingValue() throws Exception {
        this.putStringValueInCache("default", "test", "test");
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "default", "test")).header(HttpHeader.ACCEPT, "text/plain").send();
        ResponseAssertion.assertThat(response).hasEtag();
        ResponseAssertion.assertThat(response).hasHeaderMatching("ETag", "-\\d+");
    }

    @Test
    public void shouldReturnExtendedHeaders() throws Exception {
        this.putStringValueInCache("default", "test", "test");
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s?extended=true", this.restServer.getPort(), "default", "test")).header(HttpHeader.ACCEPT, "text/plain").send();
        ResponseAssertion.assertThat(response).hasExtendedHeaders();
    }

    @Test
    public void shouldGetUtf8ValueStoredInSpecificFormat() throws Exception {
        this.putStringValueInCache("default", "test", "test");
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "default", "test")).header(HttpHeader.ACCEPT, "text/plain;charset=UTF-8").send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("text/plain;charset=UTF-8");
        ResponseAssertion.assertThat(response).hasReturnedText("test");
    }

    @Test
    public void shouldGetJsonValueStoredInSpecificFormat() throws Exception {
        this.putJsonValueInCache("json", "test", "{\"name\": \"test\"}");
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "json", "test")).header(HttpHeader.ACCEPT, "application/json").send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("application/json");
        ResponseAssertion.assertThat(response).hasReturnedText("{\"name\": \"test\"}");
    }

    @Test
    public void shouldGetXmlValueStoredInSpecificFormat() throws Exception {
        this.putStringValueInCache("xml", "test", "<xml><name>test</name></xml>");
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "xml", "test")).header(HttpHeader.ACCEPT, "application/xml").send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("application/xml");
        ResponseAssertion.assertThat(response).hasReturnedText("<xml><name>test</name></xml>");
    }

    @Test
    public void shouldGetValueStoredInUnknownFormat() throws Exception {
        this.putStringValueInCache("default", "test", "test");
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "default", "test")).send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("application/octet-stream");
        ResponseAssertion.assertThat(response).hasReturnedText("test");
    }

    @Test
    public void shouldGetOctetStreamValueStoredInSpecificFormat() throws Exception {
        TestClass testClass = new TestClass();
        testClass.setName("test");
        this.putBinaryValueInCache("serialized", "test", this.convertToBytes(testClass), MediaType.APPLICATION_SERIALIZED_OBJECT);
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "serialized", "test")).send();
        TestClass convertedObject = this.convertFromBytes(response.getContent(), TestClass.class);
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType(MediaType.APPLICATION_SERIALIZED_OBJECT.toString());
        ResponseAssertion.assertThat(response).hasNoCharset();
        Assertions.assertThat((String)convertedObject.getName()).isEqualTo((Object)"test");
    }

    @Test
    public void shouldConvertExistingObjectToText() throws Exception {
        this.putStringValueInCache("default", "test", "test");
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "default", "test")).header(HttpHeader.ACCEPT, "text/plain").send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("text/plain");
        ResponseAssertion.assertThat(response).hasReturnedText("test");
    }

    @Test
    public void shouldConvertExistingObjectToTextUtf8() throws Exception {
        this.putStringValueInCache("default", "test", "test");
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "default", "test")).header(HttpHeader.ACCEPT, "text/plain;charset=utf-8").send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("text/plain");
        ResponseAssertion.assertThat(response).hasReturnedText("test");
    }

    protected void putValueInCache(String cacheName, Object key, Object testValue) {
        this.restServer.getCacheManager().getCache(cacheName).getAdvancedCache().put(key, testValue);
    }

    @Test
    public void shouldGetExistingValueWithoutOutputUsingHEAD() throws Exception {
        this.putStringValueInCache("default", "test", "test");
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "default", "test")).method(HttpMethod.HEAD).send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasNoContent();
    }

    protected void putInCache(String cacheName, Object key, String keyContentType, String value, String contentType) throws InterruptedException, ExecutionException, TimeoutException {
        Request request = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), cacheName, key)).content((ContentProvider)new StringContentProvider(value)).header("Content-type", contentType).method(HttpMethod.PUT);
        if (keyContentType != null) {
            request.header("Key-Content-type", keyContentType);
        }
        ContentResponse response = request.send();
        ResponseAssertion.assertThat(response).isOk();
    }

    protected void putInCache(String cacheName, Object key, String value, String contentType) throws InterruptedException, ExecutionException, TimeoutException {
        this.putInCache(cacheName, key, null, value, contentType);
    }

    protected void putStringValueInCache(String cacheName, String key, String value) throws InterruptedException, ExecutionException, TimeoutException {
        this.putInCache(cacheName, key, value, "text/plain; charset=utf-8");
    }

    protected void putJsonValueInCache(String cacheName, String key, String value) throws InterruptedException, ExecutionException, TimeoutException {
        this.putInCache(cacheName, key, value, "application/json; charset=utf-8");
    }

    protected void putBinaryValueInCache(String cacheName, String key, byte[] value, MediaType mediaType) throws InterruptedException, ExecutionException, TimeoutException {
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), cacheName, key)).content((ContentProvider)new BytesContentProvider((byte[][])new byte[][]{value})).header(HttpHeader.CONTENT_TYPE, mediaType.toString()).method(HttpMethod.PUT).send();
        ResponseAssertion.assertThat(response).isOk();
    }

    /*
     * Exception decompiling
     */
    private byte[] convertToBytes(Object object) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private <T> T convertFromBytes(byte[] bytes, Class<T> klass) throws IOException, ClassNotFoundException {
        try (ByteArrayInputStream bis = new ByteArrayInputStream(bytes);){
            ObjectInputStream in = new ObjectInputStream(bis);
            Object object = in.readObject();
            return (T)object;
        }
    }

    @Test
    public void shouldDeleteExistingValue() throws Exception {
        this.putStringValueInCache("default", "test", "test");
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "default", "test")).method(HttpMethod.DELETE).send();
        ResponseAssertion.assertThat(response).isOk();
        Assertions.assertThat((Map)this.restServer.getCacheManager().getCache("default")).isEmpty();
    }

    @Test
    public void shouldDeleteExistingValueWithAcceptHeader() throws Exception {
        this.putBinaryValueInCache("serialized", "test", this.convertToBytes(42), MediaType.APPLICATION_SERIALIZED_OBJECT);
        ContentResponse headResponse = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "serialized", "test")).method(HttpMethod.HEAD).header(HttpHeader.ACCEPT, "application/x-java-serialized-object").send();
        ResponseAssertion.assertThat(headResponse).isOk();
        ResponseAssertion.assertThat(headResponse).hasContentType("application/x-java-serialized-object");
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "serialized", "test")).method(HttpMethod.DELETE).header(HttpHeader.CONTENT_TYPE, "text/plain;charset=UTF-8").send();
        ResponseAssertion.assertThat(response).isOk();
        Assertions.assertThat((Map)this.restServer.getCacheManager().getCache("binary")).isEmpty();
    }

    @Test
    public void shouldDeleteNonExistingValue() throws Exception {
        this.putStringValueInCache("default", "test", "test");
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "default", "doesnt_exist")).method(HttpMethod.DELETE).send();
        ResponseAssertion.assertThat(response).isNotFound();
    }

    @Test
    public void shouldDeleteEntireCache() throws Exception {
        this.putStringValueInCache("default", "test", "test");
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s", this.restServer.getPort(), "default")).method(HttpMethod.DELETE).send();
        ResponseAssertion.assertThat(response).isOk();
        Assertions.assertThat((Map)this.restServer.getCacheManager().getCache("default")).isEmpty();
    }

    @Test
    public void shouldGetAllEntriesFromEmptyCache() throws Exception {
        ContentResponse response = this.client.newRequest("http://localhost:" + this.restServer.getPort() + "/rest/default").method(HttpMethod.GET).header("Content-Type", "text/plain; charset=utf-8").send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasReturnedText("");
    }

    @Test
    public void shouldGetAllEntriesConvertedToText() throws Exception {
        this.putStringValueInCache("textCache", "key1", "test1");
        this.putStringValueInCache("textCache", "key2", "test2");
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s", this.restServer.getPort(), "textCache")).header(HttpHeader.ACCEPT, "text/plain").send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("text/plain");
        ResponseAssertion.assertThat(response).hasReturnedText("key1\nkey2");
    }

    @Test
    public void shouldGetAllEntriesConvertedToTextUtf8() throws Exception {
        this.putStringValueInCache("textCache", "key1", "test1");
        this.putStringValueInCache("textCache", "key2", "test2");
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s", this.restServer.getPort(), "textCache")).header(HttpHeader.ACCEPT, "text/plain;charset=UTF-8").send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("text/plain;charset=UTF-8");
        ResponseAssertion.assertThat(response).hasReturnedText("key1\nkey2");
    }

    @Test
    public void shouldGetAllEntriesConvertedToTextIso_8859_1() throws Exception {
        this.putStringValueInCache("textCache", "key1", "test1");
        this.putStringValueInCache("textCache", "key2", "test2");
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s", this.restServer.getPort(), "textCache")).header(HttpHeader.ACCEPT, "text/plain; charset=ISO-8859-1").send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("text/plain; charset=ISO-8859-1");
        ResponseAssertion.assertThat(response).hasReturnedText("key1\nkey2");
    }

    @Test
    public void shouldGetAllEntriesConvertedToJson() throws Exception {
        this.putStringValueInCache("textCache", "key1", "test1");
        this.putStringValueInCache("textCache", "key2", "test2");
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s", this.restServer.getPort(), "textCache")).header(HttpHeader.ACCEPT, "application/json").send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("application/json");
        ResponseAssertion.assertThat(response).hasReturnedText("keys=[key1,key2]");
    }

    @Test
    public void shouldGetAllEntriesConvertedToXml() throws Exception {
        this.putStringValueInCache("textCache", "key1", "test1");
        this.putStringValueInCache("textCache", "key2", "test2");
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s", this.restServer.getPort(), "textCache")).header(HttpHeader.ACCEPT, "application/xml").send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("application/xml");
        ResponseAssertion.assertThat(response).hasReturnedText("<?xml version=\"1.0\" encoding=\"UTF-8\"?><keys><key>key1</key><key>key2</key></keys>");
    }

    @Test
    public void shouldGetAllEntriesConvertedToBytes() throws Exception {
        this.putStringValueInCache("default", "key1", "test1");
        this.putStringValueInCache("default", "key2", "test2");
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s", this.restServer.getPort(), "default")).header(HttpHeader.ACCEPT, "application/octet-stream").send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("application/octet-stream");
        ResponseAssertion.assertThat(response).hasReturnedText(String.format("%s\n%s", StandardConversions.bytesToHex((byte[])"key1".getBytes()), StandardConversions.bytesToHex((byte[])"key2".getBytes())));
    }

    @Test
    public void shouldAcceptMultipleAcceptHeaderValues() throws Exception {
        this.putStringValueInCache("textCache", "key1", "test1");
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "textCache", "key1")).header(HttpHeader.ACCEPT, "ignored/wrong , text/plain").send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("text/plain");
        ResponseAssertion.assertThat(response).hasReturnedText("test1");
    }

    @Test
    public void shouldNotAcceptUnknownContentType() throws Exception {
        this.putStringValueInCache("default", "key1", "test1");
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "default", "key1")).header(HttpHeader.ACCEPT, "application/wrong-content-type").send();
        ResponseAssertion.assertThat(response).isNotAcceptable();
    }

    @Test
    public void shouldNotAcceptUnknownContentTypeWithHead() throws Exception {
        this.putStringValueInCache("default", "key1", "test1");
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "default", "key1")).method(HttpMethod.HEAD).header(HttpHeader.ACCEPT, "garbage").send();
        ResponseAssertion.assertThat(response).isNotAcceptable();
    }

    @Test
    public void shouldNotReturnValueIfSendingCorrectETag() throws Exception {
        this.putStringValueInCache("default", "test", "test");
        ContentResponse firstResponse = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "default", "test")).method(HttpMethod.GET).send();
        String etagFromFirstCall = firstResponse.getHeaders().get("ETag");
        ContentResponse secondResponse = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "default", "test")).header("If-None-Match", etagFromFirstCall).method(HttpMethod.GET).send();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)etagFromFirstCall).isNotNull()).isNotEmpty();
        ResponseAssertion.assertThat(secondResponse).isNotModified();
    }

    @Test
    public void shouldReturnEntityWhenSendingWrongETag() throws Exception {
        this.putStringValueInCache("default", "test", "test");
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "default", "test")).header("If-None-Match", "Invalid-etag").method(HttpMethod.GET).send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasReturnedText("test");
    }

    @Test
    public void shouldPutTextValueInCache() throws Exception {
        ContentResponse response = this.client.POST(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "default", "test")).content((ContentProvider)new StringContentProvider("Hey!")).header("Content-type", "text/plain;charset=UTF-8").send();
        InternalCacheEntry<String, byte[]> cacheEntry = this.getCacheEntry("default", "test".getBytes());
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasEtag();
        Assertions.assertThat((String)new String((byte[])cacheEntry.getValue())).isEqualTo((Object)"Hey!");
    }

    @Test
    public void shouldReturnJsonWithDefaultConfig() throws Exception {
        this.putStringValueInCache("textCache", "test", "Hey!");
        ContentResponse getResponse = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "textCache", "test")).method(HttpMethod.GET).header("Accept", "application/json").send();
        ResponseAssertion.assertThat(getResponse).isOk();
        ResponseAssertion.assertThat(getResponse).hasReturnedText("\"Hey!\"");
    }

    @Test
    public void shouldPutUnknownFormatValueInCache() throws Exception {
        ContentResponse response = this.client.POST(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "unknown", "test")).content((ContentProvider)new StringContentProvider("Hey!")).header("Content-type", "application/unknown").send();
        InternalCacheEntry<String, byte[]> cacheEntry = this.getCacheEntry("unknown", "test".getBytes());
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasEtag();
        Assertions.assertThat((String)new String((byte[])cacheEntry.getValue())).isEqualTo((Object)"Hey!");
    }

    @Test
    public void shouldPutSerializedValueInCache() throws Exception {
        TestClass testClass = new TestClass();
        testClass.setName("test");
        ContentResponse response = this.client.POST(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "serialized", "test")).content((ContentProvider)new BytesContentProvider((byte[][])new byte[][]{this.convertToBytes(testClass)})).header("Content-type", "application/x-java-serialized-object").send();
        InternalCacheEntry<String, byte[]> cacheEntry = this.getCacheEntry("serialized", "test".getBytes());
        TestClass valueFromCache = this.convertFromBytes((byte[])cacheEntry.getValue(), TestClass.class);
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasEtag();
        Assertions.assertThat((String)valueFromCache.getName()).isEqualTo((Object)"test");
    }

    @Test
    public void shouldConflictWhenTryingToReplaceExistingEntryUsingPost() throws Exception {
        this.putStringValueInCache("default", "test", "test");
        ContentResponse response = this.client.POST(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "default", "test")).content((ContentProvider)new StringContentProvider("Hey!")).header("Content-type", "text/plain;charset=UTF-8").send();
        ResponseAssertion.assertThat(response).isConflicted();
    }

    @Test
    public void shouldUpdateEntryWhenReplacingUsingPut() throws Exception {
        this.putStringValueInCache("default", "test", "test");
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "default", "test")).content((ContentProvider)new StringContentProvider("Hey!")).header("Content-type", "text/plain;charset=UTF-8").method(HttpMethod.PUT).send();
        String valueFromCache = new String((byte[])this.getCacheEntry("default", "test".getBytes()).getValue());
        ResponseAssertion.assertThat(response).isOk();
        Assertions.assertThat((String)valueFromCache).isEqualTo((Object)"Hey!");
    }

    @Test
    public void shouldServeHtmlFile() throws Exception {
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest", this.restServer.getPort())).method(HttpMethod.GET).send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("text/html");
        ResponseAssertion.assertThat(response).hasContentEqualToFile("index.html");
    }

    @Test
    public void shouldServeBannerFile() throws Exception {
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/banner.png", this.restServer.getPort())).method(HttpMethod.GET).send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("image/png");
        ResponseAssertion.assertThat(response).hasContentEqualToFile("banner.png");
    }

    @Test
    public void shouldPutEntryWithDefaultTllAndIdleTime() throws Exception {
        ContentResponse response = this.client.POST(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "expiration", "test")).content((ContentProvider)new StringContentProvider("test")).send();
        InternalCacheEntry<String, byte[]> cacheEntry = this.getCacheEntry("expiration", "test".getBytes());
        Metadata metadata = cacheEntry.getMetadata();
        ResponseAssertion.assertThat(response).isOk();
        Assertions.assertThat((long)metadata.lifespan()).isEqualTo(45190L);
        Assertions.assertThat((long)metadata.maxIdle()).isEqualTo(1859446L);
    }

    @Test
    public void shouldPutImmortalEntryWithMinusOneTtlAndIdleTime() throws Exception {
        ContentResponse response = this.client.POST(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "expiration", "test")).content((ContentProvider)new StringContentProvider("test")).header("timeToLiveSeconds", "-1").header("maxIdleTimeSeconds", "-1").send();
        InternalCacheEntry<String, byte[]> cacheEntry = this.getCacheEntry("expiration", "test".getBytes());
        Metadata metadata = cacheEntry.getMetadata();
        ResponseAssertion.assertThat(response).isOk();
        Assertions.assertThat((long)metadata.lifespan()).isEqualTo(-1L);
        Assertions.assertThat((long)metadata.maxIdle()).isEqualTo(-1L);
    }

    @Test
    public void shouldPutImmortalEntryWithZeroTtlAndIdleTime() throws Exception {
        ContentResponse response = this.client.POST(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "expiration", "test")).content((ContentProvider)new StringContentProvider("test")).header("timeToLiveSeconds", "0").header("maxIdleTimeSeconds", "0").send();
        InternalCacheEntry<String, byte[]> cacheEntry = this.getCacheEntry("expiration", "test".getBytes());
        Metadata metadata = cacheEntry.getMetadata();
        ResponseAssertion.assertThat(response).isOk();
        Assertions.assertThat((long)metadata.lifespan()).isEqualTo(45190L);
        Assertions.assertThat((long)metadata.maxIdle()).isEqualTo(1859446L);
    }

    @Test
    public void testErrorPropagation() throws Exception {
        this.putStringValueInCache("xml", "key", "<value/>");
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "xml", "key")).header(HttpHeader.ACCEPT, "application/json").method(HttpMethod.GET).send();
        ResponseAssertion.assertThat(response).isNotAcceptable();
        ResponseAssertion.assertThat(response).containsReturnedText("Cannot convert to application/json");
    }

    @Test
    public void shouldPutEntryWithTtlAndIdleTime() throws Exception {
        ContentResponse response = this.client.POST(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "expiration", "test")).content((ContentProvider)new StringContentProvider("test")).header("timeToLiveSeconds", "50").header("maxIdleTimeSeconds", "50").send();
        InternalCacheEntry<String, byte[]> cacheEntry = this.getCacheEntry("expiration", "test".getBytes());
        Metadata metadata = cacheEntry.getMetadata();
        ResponseAssertion.assertThat(response).isOk();
        Assertions.assertThat((long)metadata.lifespan()).isEqualTo(50000L);
        Assertions.assertThat((long)metadata.maxIdle()).isEqualTo(50000L);
    }

    @Test
    public void shouldPutLargeObject() throws Exception {
        ByteBuffer payload = ByteBuffer.allocate(1000000);
        ContentResponse response = this.client.POST(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "binary", "test")).content((ContentProvider)new ByteBufferContentProvider(new ByteBuffer[]{payload})).send();
        InternalCacheEntry<String, byte[]> cacheEntry = this.getCacheEntry("binary", "test".getBytes());
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasEtag();
        Assertions.assertThat((int)((byte[])cacheEntry.getValue()).length).isEqualTo(1000000);
    }

    @Test
    public void shouldFailTooLargeObject() throws Exception {
        ByteBuffer payload = ByteBuffer.allocate(1100000);
        ContentResponse response = this.client.POST(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "default", "test")).content((ContentProvider)new ByteBufferContentProvider(new ByteBuffer[]{payload})).send();
        ResponseAssertion.assertThat(response).isPayloadTooLarge();
    }

    @Test
    public void testWildcardAccept() throws Exception {
        this.putStringValueInCache("default", "test", "test");
        ContentResponse getResponse = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "default", "test")).accept(new String[]{"*/*"}).method(HttpMethod.GET).send();
        ResponseAssertion.assertThat(getResponse).isOk();
        ResponseAssertion.assertThat(getResponse).hasReturnedText("test");
    }

    protected ContentResponse get(String cacheName, Object key, String keyContentType, String acceptHeader) throws Exception {
        Request request = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), cacheName, key)).method(HttpMethod.GET);
        if (acceptHeader != null) {
            request.accept(new String[]{acceptHeader});
        }
        if (keyContentType != null) {
            request.header("Key-Content-Type", keyContentType);
        }
        ContentResponse response = request.send();
        ResponseAssertion.assertThat(response).isOk();
        return response;
    }

    protected ContentResponse get(String cacheName, Object key, String acceptHeader) throws Exception {
        Request request = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), cacheName, key)).method(HttpMethod.GET);
        if (acceptHeader != null) {
            request.accept(new String[]{acceptHeader});
        }
        ContentResponse response = request.send();
        ResponseAssertion.assertThat(response).isOk();
        return response;
    }

    @Test
    public void shouldAcceptUrlEncodedContentForDefaultCache() throws Exception {
        String value = "word1 word2";
        String urlEncoded = URLEncoder.encode(value, "UTF-8");
        this.putBinaryValueInCache("default", "test", urlEncoded.getBytes(StandardCharsets.UTF_8), MediaType.APPLICATION_WWW_FORM_URLENCODED);
        ContentResponse getResponse = this.get("default", "test", "text/plain");
        ResponseAssertion.assertThat(getResponse).hasReturnedText(value);
        ResponseAssertion.assertThat(getResponse).hasContentType("text/plain");
    }

    @Test
    public void shouldNegotiateFromDefaultCacheWithoutAccept() throws Exception {
        this.putStringValueInCache("default", "test", "test");
        ContentResponse getResponse = this.get("default", "test", null);
        ResponseAssertion.assertThat(getResponse).hasReturnedText("test");
        ResponseAssertion.assertThat(getResponse).hasContentType("application/octet-stream");
    }

    @Test
    public void shouldNegotiateFromDefaultCacheWithAccept() throws Exception {
        this.putStringValueInCache("default", "test", "test");
        ContentResponse jsonResponse = this.get("default", "test", "application/json");
        ResponseAssertion.assertThat(jsonResponse).hasReturnedText("\"test\"");
        ResponseAssertion.assertThat(jsonResponse).hasContentType("application/json");
        ContentResponse xmlResponse = this.get("default", "test", "text/plain");
        ResponseAssertion.assertThat(xmlResponse).hasReturnedText("test");
        ResponseAssertion.assertThat(xmlResponse).hasContentType("text/plain");
        ContentResponse binaryResponse = this.get("default", "test", "application/octet-stream");
        ResponseAssertion.assertThat(binaryResponse).hasReturnedBytes("test".getBytes(StandardCharsets.UTF_8));
        ResponseAssertion.assertThat(binaryResponse).hasContentType("application/octet-stream");
    }

    @Test
    public void shouldNegotiateFromDefaultCacheWithBinary() throws Exception {
        TestClass testClass = new TestClass();
        byte[] javaSerialized = new JavaSerializationMarshaller().objectToByteBuffer((Object)testClass);
        this.putBinaryValueInCache("default", "test", javaSerialized, MediaType.APPLICATION_OCTET_STREAM);
        ContentResponse response = this.get("default", "test", "application/octet-stream");
        ResponseAssertion.assertThat(response).hasContentType("application/octet-stream");
        ResponseAssertion.assertThat(response).hasReturnedBytes(javaSerialized);
    }

    @Test
    public void shouldNegotiateFromDefaultCacheWithWildcardAccept() throws Exception {
        this.putStringValueInCache("default", "test", "test");
        ContentResponse getResponse = this.get("default", "test", "*/*");
        ResponseAssertion.assertThat(getResponse).isOk();
        ResponseAssertion.assertThat(getResponse).hasReturnedText("test");
        ResponseAssertion.assertThat(getResponse).hasContentType("application/octet-stream");
    }

    @Test
    public void shouldNegotiateFromDefaultCacheWithMultipleAccept() throws Exception {
        this.putStringValueInCache("default", "test", "test");
        ContentResponse sameWeightResponse = this.get("default", "test", "text/html,application/xhtml+xml,*/*");
        ResponseAssertion.assertThat(sameWeightResponse).isOk();
        ResponseAssertion.assertThat(sameWeightResponse).hasReturnedText("test");
        ResponseAssertion.assertThat(sameWeightResponse).hasContentType("application/octet-stream");
        ContentResponse weightedResponse = this.get("default", "test", "text/plain;q=0.1, application/json;q=0.8, */*;q=0.7");
        ResponseAssertion.assertThat(weightedResponse).isOk();
        ResponseAssertion.assertThat(weightedResponse).hasReturnedText("\"test\"");
        ResponseAssertion.assertThat(weightedResponse).hasContentType("application/json");
    }

    @Test
    public void shouldNegotiateFromJsonCacheWithoutAccept() throws Exception {
        String cacheName = "json";
        String key = "1";
        String value = "{\"id\": 1}";
        this.putJsonValueInCache(cacheName, key, value);
        ContentResponse getResponse = this.get(cacheName, key, null);
        ResponseAssertion.assertThat(getResponse).hasReturnedText(value);
        ResponseAssertion.assertThat(getResponse).hasContentType("application/json");
    }

    @Test
    public void shouldNegotiateFromJsonCacheWithAccept() throws Exception {
        String cacheName = "json";
        String key = "1";
        String value = "{\"id\": 1}";
        this.putJsonValueInCache(cacheName, key, value);
        ContentResponse jsonResponse = this.get(cacheName, key, "application/json");
        ResponseAssertion.assertThat(jsonResponse).hasReturnedText(value);
        ResponseAssertion.assertThat(jsonResponse).hasContentType("application/json");
        ContentResponse textResponse = this.get(cacheName, key, "text/plain");
        ResponseAssertion.assertThat(textResponse).hasReturnedBytes(value.getBytes(StandardCharsets.UTF_8));
        ResponseAssertion.assertThat(textResponse).hasContentType("text/plain");
    }

    @Test
    public void shouldNegotiateFromJsonCacheWithWildcardAccept() throws Exception {
        String cacheName = "json";
        String key = "1";
        String value = "{\"id\": 1}";
        this.putJsonValueInCache(cacheName, key, value);
        ContentResponse jsonResponse = this.get(cacheName, key, "*/*");
        ResponseAssertion.assertThat(jsonResponse).isOk();
        ResponseAssertion.assertThat(jsonResponse).hasReturnedText(value);
        ResponseAssertion.assertThat(jsonResponse).hasContentType("application/json");
    }

    @Test
    public void shouldNegotiateFromJsonCacheWithMultipleAccept() throws Exception {
        String cacheName = "json";
        String key = "1";
        String value = "{\"id\": 1}";
        this.putJsonValueInCache(cacheName, key, value);
        ContentResponse jsonResponse = this.get(cacheName, key, "text/html,*/*");
        ResponseAssertion.assertThat(jsonResponse).isOk();
        ResponseAssertion.assertThat(jsonResponse).hasReturnedText(value);
        ResponseAssertion.assertThat(jsonResponse).hasContentType("application/json");
        ContentResponse binaryResponse = this.get(cacheName, key, "application/xml, text/plain; q=0.71, */*;q=0.7");
        ResponseAssertion.assertThat(binaryResponse).isOk();
        ResponseAssertion.assertThat(binaryResponse).hasReturnedText(value);
        ResponseAssertion.assertThat(binaryResponse).hasContentType("text/plain");
    }

    @Test
    public void shouldNegotiateOnlySupportedFromDefaultCacheWithMultipleAccept() throws Exception {
        String value = "<test/>";
        this.putStringValueInCache("default", "test", value);
        ContentResponse getResponse = this.get("default", "test", "text/html, application/xml");
        ResponseAssertion.assertThat(getResponse).hasReturnedText("<test/>");
        ResponseAssertion.assertThat(getResponse).hasContentType("application/xml");
    }

    @Test
    public void shouldHandleInvalidPath() throws Exception {
        Request browserRequest = this.client.newRequest(String.format("http://localhost:%d/rest/%s", this.restServer.getPort(), "asdjsad")).header(HttpHeader.ACCEPT, "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8").method(HttpMethod.GET);
        ContentResponse response = browserRequest.send();
        ResponseAssertion.assertThat(response).isNotFound();
    }

    @Test
    public void shouldHandleIncompletePath() throws Exception {
        Request req = this.client.newRequest(String.format("http://localhost:%d/rest/%s?action", this.restServer.getPort(), "default")).method(HttpMethod.GET);
        ContentResponse response = req.send();
        ResponseAssertion.assertThat(response).isBadRequest();
    }

    @Test
    public void testIntegerKeysXmlToTextValues() throws Exception {
        Integer key = 123;
        String keyContentType = "application/x-java-object;type=java.lang.Integer";
        String valueContentType = "application/xml; charset=UTF-8";
        String value = "<root>test</root>";
        this.putInCache("default", key, keyContentType, value, valueContentType);
        ContentResponse response = this.get("default", key, keyContentType, "text/plain");
        ResponseAssertion.assertThat(response).hasReturnedText(value);
    }

    @Test
    public void testIntKeysAndJSONToTextValues() throws Exception {
        Integer key = 1234;
        String keyContentType = "application/x-java-object;type=java.lang.Integer";
        String value = "{\"a\": 1}";
        this.putInCache("default", key, keyContentType, value, "application/json");
        ContentResponse response = this.get("default", key, keyContentType, "text/plain");
        ResponseAssertion.assertThat(response).hasReturnedText(value);
    }

    @Test
    public void testIntKeysTextToXMLValues() throws Exception {
        Integer key = 12345;
        String keyContentType = "application/x-java-object;type=java.lang.Integer";
        String value = "<foo>bar</foo>";
        this.putInCache("default", key, keyContentType, value, "text/plain");
        ContentResponse response = this.get("default", key, keyContentType, "application/xml");
        ResponseAssertion.assertThat(response).hasReturnedText(value);
    }

    @Test
    public void testInvalidXMLConversion() throws Exception {
        String key = "invalid-xml-key";
        String invalidXML = "foo";
        this.putInCache("default", key, invalidXML, "text/plain");
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "default", key)).header(HttpHeader.ACCEPT, "application/xml").method(HttpMethod.GET).send();
        ResponseAssertion.assertThat(response).containsReturnedText("<string>foo</string>");
    }
}

