/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.ssl.OpenSsl;
import io.netty.util.CharsetUtil;
import java.util.Queue;
import org.assertj.core.api.Assertions;
import org.infinispan.commons.test.skip.SkipTestNG;
import org.infinispan.rest.helper.RestServerHelper;
import org.infinispan.rest.http2.Http2Client;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.fwk.TestResourceTracker;
import org.testng.SkipException;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="rest.Http2Test")
public final class Http2Test
extends AbstractInfinispanTest {
    public static final String KEY_STORE_PATH = Http2Test.class.getClassLoader().getResource("./client.p12").getPath();
    private Http2Client client;
    private RestServerHelper restServer;

    @BeforeMethod
    public void afterMethod() {
        if (this.restServer != null) {
            this.restServer.stop();
        }
        if (this.client != null) {
            this.client.stop();
        }
    }

    @Test
    public void shouldUpgradeUsingALPN() throws Exception {
        SkipTestNG.skipSinceJDK((int)10);
        if (!OpenSsl.isAlpnSupported()) {
            throw new SkipException("OpenSSL is not present, can not test TLS/ALPN support");
        }
        this.restServer = RestServerHelper.defaultRestServer("http2testcache").withKeyStore(KEY_STORE_PATH, "secret", "pkcs12").start(TestResourceTracker.getCurrentTestShortName());
        this.client = Http2Client.newClientWithAlpn(KEY_STORE_PATH, "secret");
        this.client.start(this.restServer.getHost(), this.restServer.getPort());
        DefaultFullHttpRequest putValueInCacheRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "/rest/http2testcache/test", Unpooled.wrappedBuffer((byte[])"test".getBytes(CharsetUtil.UTF_8)));
        this.client.sendRequest((FullHttpRequest)putValueInCacheRequest);
        Queue<FullHttpResponse> responses = this.client.getResponses();
        Assertions.assertThat(responses).hasSize(1);
        Assertions.assertThat((int)responses.element().status().code()).isEqualTo(200);
        Assertions.assertThat((int)this.restServer.getCacheManager().getCache("http2testcache").size()).isEqualTo(1);
    }

    @Test
    public void shouldUpgradeUsingHTTP11Upgrade() throws Exception {
        this.restServer = RestServerHelper.defaultRestServer("http2testcache").start(TestResourceTracker.getCurrentTestShortName());
        this.client = Http2Client.newClientWithHttp11Upgrade();
        this.client.start(this.restServer.getHost(), this.restServer.getPort());
        DefaultFullHttpRequest putValueInCacheRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "/rest/http2testcache/test", Unpooled.wrappedBuffer((byte[])"test".getBytes(CharsetUtil.UTF_8)));
        this.client.sendRequest((FullHttpRequest)putValueInCacheRequest);
        Queue<FullHttpResponse> responses = this.client.getResponses();
        Assertions.assertThat(responses).hasSize(1);
        Assertions.assertThat((int)responses.element().status().code()).isEqualTo(200);
        Assertions.assertThat((int)this.restServer.getCacheManager().getCache("http2testcache").size()).isEqualTo(1);
    }
}

