/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http.cors.CorsConfig;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2ServerUpgradeCodec;
import io.netty.handler.codec.http2.HttpToHttp2ConnectionHandler;
import io.netty.handler.codec.http2.HttpToHttp2ConnectionHandlerBuilder;
import io.netty.handler.codec.http2.InboundHttp2ToHttpAdapter;
import io.netty.handler.codec.http2.InboundHttp2ToHttpAdapterBuilder;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import io.netty.util.AsciiString;
import java.util.List;
import org.infinispan.rest.Http11RequestHandler;
import org.infinispan.rest.Http20RequestHandler;
import org.infinispan.rest.RestServer;
import org.infinispan.rest.configuration.RestServerConfiguration;
import org.infinispan.rest.cors.CorsHandler;

@ChannelHandler.Sharable
public class Http11To2UpgradeHandler
extends ApplicationProtocolNegotiationHandler {
    protected static final int MAX_INITIAL_LINE_SIZE = 4096;
    protected static final int MAX_HEADER_SIZE = 8192;
    protected final RestServer restServer;
    private final List<CorsConfig> corsRules;

    public Http11To2UpgradeHandler(RestServer restServer) {
        super("http/1.1");
        this.restServer = restServer;
        this.corsRules = ((RestServerConfiguration)restServer.getConfiguration()).getCorsRules();
    }

    public void configurePipeline(ChannelHandlerContext ctx, String protocol) throws Exception {
        this.configurePipeline(ctx.pipeline(), protocol);
    }

    public void configurePipeline(ChannelPipeline pipeline, String protocol) {
        if ("h2".equals(protocol)) {
            this.configureHttp2(pipeline);
            return;
        }
        if ("http/1.1".equals(protocol)) {
            this.configureHttp1(pipeline);
            return;
        }
        throw new IllegalStateException("unknown protocol: " + protocol);
    }

    protected void configureHttp2(ChannelPipeline pipeline) {
        pipeline.addLast(new ChannelHandler[]{this.getHttp11To2ConnectionHandler()});
        pipeline.addLast("rest-handler-http2", this.getHttp2Handler());
    }

    protected void configureHttp1(ChannelPipeline pipeline) {
        RestServerConfiguration configuration = (RestServerConfiguration)this.restServer.getConfiguration();
        HttpServerCodec httpCodec = new HttpServerCodec(4096, 8192, configuration.maxContentLength());
        pipeline.addLast(new ChannelHandler[]{httpCodec});
        if (!this.corsRules.isEmpty()) {
            pipeline.addLast(new ChannelHandler[]{new CorsHandler(this.corsRules, true)});
        }
        pipeline.addLast(new ChannelHandler[]{new HttpContentCompressor(configuration.getCompressionLevel())});
        pipeline.addLast(new ChannelHandler[]{new HttpServerUpgradeHandler((HttpServerUpgradeHandler.SourceCodec)httpCodec, protocol -> {
            if (AsciiString.contentEquals((CharSequence)Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME, (CharSequence)protocol)) {
                return new Http2ServerUpgradeCodec((Http2ConnectionHandler)this.getHttp11To2ConnectionHandler());
            }
            return null;
        })});
        pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(this.maxContentLength())});
        pipeline.addLast("rest-handler", this.getHttp1Handler());
    }

    protected int maxContentLength() {
        return ((RestServerConfiguration)this.restServer.getConfiguration()).maxContentLength() + 4096 + 8192;
    }

    protected HttpToHttp2ConnectionHandler getHttp11To2ConnectionHandler() {
        DefaultHttp2Connection connection = new DefaultHttp2Connection(true);
        InboundHttp2ToHttpAdapter listener = new InboundHttp2ToHttpAdapterBuilder((Http2Connection)connection).propagateSettings(true).validateHttpHeaders(false).maxContentLength(this.maxContentLength()).build();
        return new HttpToHttp2ConnectionHandlerBuilder().frameListener((Http2FrameListener)listener).connection((Http2Connection)connection).build();
    }

    public ChannelHandler getHttp1Handler() {
        return new Http11RequestHandler(this.restServer);
    }

    public ChannelHandler getHttp2Handler() {
        return new Http20RequestHandler(this.restServer);
    }

    public ApplicationProtocolConfig getAlpnConfiguration() {
        if (((RestServerConfiguration)this.restServer.getConfiguration()).ssl().enabled()) {
            return new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"h2", "http/1.1"});
        }
        return null;
    }
}

