/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.logging;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.util.StringContentProvider;
import org.eclipse.jetty.http.HttpMethod;
import org.infinispan.commons.test.skip.StringLogAppender;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.rest.helper.RestServerHelper;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TestResourceTracker;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="rest.RestAccessLoggingTest")
public class RestAccessLoggingTest
extends SingleCacheManagerTest {
    public static final String LOG_FORMAT = "%X{address} %X{user} [%d{dd/MMM/yyyy:HH:mm:ss z}] \"%X{method} %m %X{protocol}\" %X{status} %X{requestSize} %X{responseSize} %X{duration}";
    private StringLogAppender logAppender;
    private RestServerHelper restServer;
    private HttpClient client;

    protected EmbeddedCacheManager createCacheManager() {
        return TestCacheManagerFactory.createCacheManager();
    }

    protected void setup() throws Exception {
        super.setup();
        this.logAppender = new StringLogAppender("org.infinispan.REST_ACCESS_LOG", Level.TRACE, t -> t.getName().startsWith("REST-RestAccessLoggingTest-ServerIO-"), (Layout)PatternLayout.newBuilder().withPattern(LOG_FORMAT).build());
        this.logAppender.install();
        this.restServer = new RestServerHelper(this.cacheManager);
        this.restServer.start(TestResourceTracker.getCurrentTestShortName());
        this.client = new HttpClient();
        this.client.start();
    }

    protected void teardown() {
        try {
            this.logAppender.uninstall();
            this.client.stop();
            this.restServer.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.teardown();
    }

    public void testRestAccessLog() throws Exception {
        this.client.newRequest(String.format("http://localhost:%d/rest/default/key", this.restServer.getPort())).content((ContentProvider)new StringContentProvider("value")).header("Content-type", "text/plain; charset=utf-8").method(HttpMethod.PUT).send();
        this.restServer.stop();
        String logline = this.logAppender.getLog(0).toString();
        AssertJUnit.assertTrue((String)logline, (boolean)logline.matches("^127\\.0\\.0\\.1 - \\[\\d+/\\w+/\\d+:\\d+:\\d+:\\d+ [+-]?\\w+\\] \"PUT /rest/default/key HTTP/1\\.1\" 404 \\d+ \\d+ \\d+$"));
    }
}

