/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.http2;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.ssl.SslContext;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import org.infinispan.IllegalLifecycleStateException;
import org.infinispan.rest.http2.CommunicationInitializer;
import org.infinispan.rest.http2.Http11ClientInitializer;
import org.infinispan.rest.http2.Http2ClientInitializer;
import org.infinispan.rest.http2.NettyTruststoreUtil;

public class NettyHttpClient {
    private final SslContext sslCtx;
    private final EventLoopGroup workerGroup = new NioEventLoopGroup();
    private Channel channel;
    private CommunicationInitializer initializer;

    public NettyHttpClient(SslContext sslCtx, CommunicationInitializer initializer) {
        this.sslCtx = sslCtx;
        this.initializer = initializer;
    }

    public static NettyHttpClient newHttp2ClientWithHttp11Upgrade() {
        return new NettyHttpClient(null, new Http2ClientInitializer(null, Integer.MAX_VALUE));
    }

    public static NettyHttpClient newHttp11Client() {
        return new NettyHttpClient(null, new Http11ClientInitializer(null, Integer.MAX_VALUE));
    }

    public static NettyHttpClient newHttp2ClientWithALPN(String keystorePath, String keystorePassword) throws Exception {
        SslContext sslContext = NettyTruststoreUtil.createTruststoreContext(keystorePath, keystorePassword.toCharArray(), "h2");
        return new NettyHttpClient(sslContext, new Http2ClientInitializer(sslContext, Integer.MAX_VALUE));
    }

    public void start(String host, int port) throws Exception {
        Bootstrap b = new Bootstrap();
        b.group(this.workerGroup);
        b.channel(NioSocketChannel.class);
        b.option(ChannelOption.SO_KEEPALIVE, (Object)true);
        b.remoteAddress(host, port);
        b.handler((ChannelHandler)this.initializer);
        this.channel = b.connect().syncUninterruptibly().channel();
        System.out.println("Connected to [" + host + ':' + port + ']');
        this.initializer.upgradeToHttp2IfNeeded();
    }

    public void stop() {
        try {
            this.workerGroup.shutdownGracefully(100L, 15000L, TimeUnit.MILLISECONDS).sync();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalLifecycleStateException((Throwable)e);
        }
    }

    public Queue<FullHttpResponse> getResponses() {
        return this.initializer.getCommunicationHandler().getResponses();
    }

    public void sendRequest(FullHttpRequest request) {
        this.initializer.getCommunicationHandler().sendRequest(request, this.sslCtx, this.channel);
    }
}

