/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.http2;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslContext;
import org.infinispan.rest.http2.CommunicationHandler;
import org.infinispan.rest.http2.CommunicationInitializer;
import org.infinispan.rest.http2.Http11ResponseHandler;

public class Http11ClientInitializer
extends CommunicationInitializer {
    private final SslContext sslCtx;
    private final int maxContentLength;
    private final Http11ResponseHandler communicationHandler = new Http11ResponseHandler();

    public Http11ClientInitializer(SslContext sslCtx, int maxContentLength) {
        this.sslCtx = sslCtx;
        this.maxContentLength = maxContentLength;
    }

    public void initChannel(SocketChannel ch) throws Exception {
        ChannelPipeline p = ch.pipeline();
        if (this.sslCtx != null) {
            p.addLast(new ChannelHandler[]{this.sslCtx.newHandler(ch.alloc())});
        }
        p.addLast(new ChannelHandler[]{new HttpClientCodec()});
        p.addLast(new ChannelHandler[]{new HttpContentDecompressor()});
        p.addLast(new ChannelHandler[]{new HttpObjectAggregator(this.maxContentLength)});
        p.addLast(new ChannelHandler[]{this.communicationHandler});
        p.addLast(new ChannelHandler[]{new LoggingHandler(LogLevel.TRACE)});
    }

    @Override
    public CommunicationHandler getCommunicationHandler() {
        return this.communicationHandler;
    }
}

