/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.profiling;

import io.netty.util.internal.logging.InternalLoggerFactory;
import io.netty.util.internal.logging.JdkLoggerFactory;
import java.util.concurrent.TimeUnit;
import org.infinispan.rest.helper.RestServerHelper;
import org.infinispan.rest.profiling.BenchmarkHttpClient;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.testng.annotations.Test;

public class Http11VsHttp20Benchmark {
    private static final int MEASUREMENT_ITERATIONS_COUNT = 10;
    private static final int WARMUP_ITERATIONS_COUNT = 10;

    @Test
    public void performHttp11VsHttp20Test() throws Exception {
        Options opt = new OptionsBuilder().include(this.getClass().getName() + ".*").mode(Mode.AverageTime).timeUnit(TimeUnit.MILLISECONDS).warmupIterations(10).measurementIterations(10).threads(1).forks(1).shouldFailOnError(true).shouldDoGC(true).build();
        new Runner(opt).run();
    }

    @State(value=Scope.Benchmark)
    public static class BenchmarkState {
        private static final String KEY_STORE_PATH = BenchmarkState.class.getClassLoader().getResource("./client.jks").getPath();
        private static final String TRUST_STORE_PATH = BenchmarkState.class.getClassLoader().getResource("./client.jks").getPath();
        private final String EXISTING_KEY = "existing_key";
        private final String NON_EXISTING_KEY = "non_existing_key";
        @Param(value={"1", "2", "4", "8"})
        public int httpClientThreads;
        @Param(value={"true", "false"})
        public boolean useTLS;
        @Param(value={"true", "false"})
        public boolean useHttp2;
        private RestServerHelper restServer;
        private BenchmarkHttpClient client;

        @Setup
        public void setup() throws Exception {
            InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)JdkLoggerFactory.INSTANCE);
            System.setProperty("infinispan.server.channel.epoll", "false");
            this.restServer = RestServerHelper.defaultRestServer(new String[0]);
            if (this.useTLS) {
                this.client = new BenchmarkHttpClient(KEY_STORE_PATH, "secret", TRUST_STORE_PATH, "secret");
                this.restServer.withKeyStore(KEY_STORE_PATH, "secret", "pkcs12");
            } else {
                this.client = new BenchmarkHttpClient();
            }
            this.restServer.start(this.getClass().getSimpleName());
            this.restServer.getCacheManager().getCache().put((Object)"existing_key", (Object)"test");
            this.client.start(this.restServer.getHost(), this.restServer.getPort(), this.httpClientThreads, this.useHttp2);
        }

        @TearDown
        public void tearDown() throws Exception {
            this.restServer.stop();
            this.client.stop();
        }

        @Benchmark
        @OperationsPerInvocation(value=100)
        public void measure_put() throws Exception {
            if (this.useHttp2 && this.httpClientThreads > 1) {
                return;
            }
            this.client.performPuts(100);
        }

        @Benchmark
        @OperationsPerInvocation(value=100)
        public void measure_get() throws Exception {
            if (this.useHttp2 && this.httpClientThreads > 1) {
                return;
            }
            this.client.performGets(0, 100, "existing_key", "non_existing_key");
        }
    }
}

