/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.router.router.impl.rest.handlers;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpRequest;
import java.lang.invoke.MethodHandles;
import java.util.Optional;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.rest.Http11RequestHandler;
import org.infinispan.server.router.RoutingTable;
import org.infinispan.server.router.logging.RouterLogger;
import org.infinispan.server.router.routes.PrefixedRouteSource;
import org.infinispan.server.router.routes.Route;
import org.infinispan.server.router.routes.rest.RestServerRouteDestination;

public class ChannelInboundHandlerDelegator
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private static final RouterLogger logger = (RouterLogger)LogFactory.getLog(MethodHandles.lookup().lookupClass(), RouterLogger.class);
    private final RoutingTable routingTable;

    public ChannelInboundHandlerDelegator(RoutingTable routingTable) {
        this.routingTable = routingTable;
    }

    protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest msg) throws Exception {
        String[] uriSplitted = msg.uri().split("/");
        if (uriSplitted.length < 2) {
            throw logger.noRouteFound();
        }
        String context = uriSplitted[2];
        logger.debugf("Decoded context %s", context);
        Optional<Route> route = this.routingTable.streamRoutes(PrefixedRouteSource.class, RestServerRouteDestination.class).filter(r -> ((PrefixedRouteSource)r.getRouteSource()).getRoutePrefix().equals(context)).findAny();
        RestServerRouteDestination routeDestination = (RestServerRouteDestination)route.orElseThrow(() -> logger.noRouteFound()).getRouteDestination();
        Http11RequestHandler restHandler = (Http11RequestHandler)routeDestination.getRestServer().getRestChannelInitializer().getHttp11To2UpgradeHandler().getHttp1Handler();
        String uriWithoutMultiTenantPrefix = "";
        for (int i = 0; i < uriSplitted.length; ++i) {
            if (i == 1) continue;
            uriWithoutMultiTenantPrefix = uriWithoutMultiTenantPrefix + uriSplitted[i];
            if (i >= uriSplitted.length - 1) continue;
            uriWithoutMultiTenantPrefix = uriWithoutMultiTenantPrefix + "/";
        }
        msg.setUri(uriWithoutMultiTenantPrefix);
        restHandler.channelRead0(ctx, msg);
    }
}

