/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.router.router.impl.singleport;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.infinispan.rest.Http11To2UpgradeHandler;
import org.infinispan.rest.RestServer;
import org.infinispan.server.core.ProtocolServer;

public class SinglePortUpgradeHandler
extends Http11To2UpgradeHandler {
    private final boolean useAlpn;
    private final Map<String, ProtocolServer> upgradeServers;

    public SinglePortUpgradeHandler(boolean useAlpn, RestServer restServer, Map<String, ProtocolServer> upgradeServers) {
        super(restServer);
        this.useAlpn = useAlpn;
        this.upgradeServers = upgradeServers;
    }

    public void configurePipeline(ChannelPipeline pipeline, String protocol) {
        if ("h2".equals(protocol)) {
            this.configureHttp2(pipeline);
            return;
        }
        if ("http/1.1".equals(protocol)) {
            this.configureHttp1(pipeline);
            return;
        }
        ProtocolServer protocolServer = this.upgradeServers.get(protocol);
        if (protocolServer != null) {
            pipeline.addLast(new ChannelHandler[]{protocolServer.getInitializer()});
            return;
        }
        throw new IllegalStateException("unknown protocol: " + protocol);
    }

    public ApplicationProtocolConfig getAlpnConfiguration() {
        if (this.useAlpn) {
            ArrayList<String> supportedProtocols = new ArrayList<String>();
            supportedProtocols.add("h2");
            supportedProtocols.add("http/1.1");
            supportedProtocols.addAll(this.upgradeServers.keySet());
            return new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, supportedProtocols);
        }
        return null;
    }

    protected HttpServerUpgradeHandler.UpgradeCodec upgradeCodecForHttp11(CharSequence protocol) {
        HttpServerUpgradeHandler.UpgradeCodec upgradeCodec = super.upgradeCodecForHttp11(protocol);
        if (upgradeCodec == null && this.upgradeServers.containsKey(protocol)) {
            final ProtocolServer protocolServer = this.upgradeServers.get(protocol);
            upgradeCodec = new HttpServerUpgradeHandler.UpgradeCodec(){

                public Collection<CharSequence> requiredUpgradeHeaders() {
                    return Collections.emptyList();
                }

                public boolean prepareUpgradeResponse(ChannelHandlerContext ctx, FullHttpRequest upgradeRequest, HttpHeaders upgradeHeaders) {
                    return true;
                }

                public void upgradeTo(ChannelHandlerContext ctx, FullHttpRequest upgradeRequest) {
                    ctx.pipeline().addLast(new ChannelHandler[]{protocolServer.getInitializer()});
                }
            };
        }
        return upgradeCodec;
    }

    public Map<String, ProtocolServer> getUpgradeServers() {
        return this.upgradeServers;
    }
}

