/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.router.utils;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;

public class RestClient {
    private final HttpClient client = new DefaultHttpClient();
    private final String baseUri;
    private String cache;

    public RestClient(String uri) {
        this.baseUri = uri;
    }

    public RestClient cache(String cache) {
        this.cache = cache;
        return this;
    }

    public String get(String key) {
        try {
            HttpGet getRequest = new HttpGet(this.constructPath(this.baseUri, this.cache, key));
            return EntityUtils.toString((HttpEntity)this.client.execute((HttpUriRequest)getRequest).getEntity());
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void put(String key, String value) {
        try {
            HttpPost putRequest = new HttpPost(this.constructPath(this.baseUri, this.cache, key));
            putRequest.setEntity((HttpEntity)new StringEntity(value));
            EntityUtils.consume((HttpEntity)this.client.execute((HttpUriRequest)putRequest).getEntity());
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    String constructPath(String baseUri, String cache, String key) {
        return baseUri + "/" + cache + "/" + key;
    }
}

