/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.router.integration;

import java.lang.invoke.MethodHandles;
import java.net.InetAddress;
import org.assertj.core.api.Assertions;
import org.infinispan.commons.test.TestResourceTracker;
import org.infinispan.rest.RestServer;
import org.infinispan.server.router.Router;
import org.infinispan.server.router.configuration.builder.RouterConfigurationBuilder;
import org.infinispan.server.router.router.EndpointRouter;
import org.infinispan.server.router.routes.Route;
import org.infinispan.server.router.routes.RouteDestination;
import org.infinispan.server.router.routes.RouteSource;
import org.infinispan.server.router.routes.rest.RestRouteSource;
import org.infinispan.server.router.routes.rest.RestServerRouteDestination;
import org.infinispan.server.router.utils.RestClient;
import org.infinispan.server.router.utils.RestTestingUtil;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class RestEndpointRouterTest {
    private RestServer restServer1;
    private RestServer restServer2;
    private Router router;

    @BeforeClass
    public static void beforeClass() {
        TestResourceTracker.testStarted((String)MethodHandles.lookup().lookupClass().toString());
    }

    @AfterClass
    public static void afterClass() {
        TestResourceTracker.testFinished((String)MethodHandles.lookup().lookupClass().toString());
    }

    @After
    public void tearDown() {
        this.router.stop();
        this.restServer1.getCacheManager().stop();
        this.restServer1.stop();
        this.restServer2.getCacheManager().stop();
        this.restServer2.stop();
    }

    @Test
    public void shouldRouteToProperRestServerBasedOnPath() {
        this.restServer1 = RestTestingUtil.createDefaultRestServer("rest1", "default");
        this.restServer2 = RestTestingUtil.createDefaultRestServer("rest2", "default");
        RestServerRouteDestination rest1Destination = new RestServerRouteDestination("rest1", this.restServer1);
        RestRouteSource rest1Source = new RestRouteSource("rest1");
        Route routeToRest1 = new Route((RouteSource)rest1Source, (RouteDestination)rest1Destination);
        RestServerRouteDestination rest2Destination = new RestServerRouteDestination("rest2", this.restServer2);
        RestRouteSource rest2Source = new RestRouteSource("rest2");
        Route routeToRest2 = new Route((RouteSource)rest2Source, (RouteDestination)rest2Destination);
        RouterConfigurationBuilder routerConfigurationBuilder = new RouterConfigurationBuilder();
        routerConfigurationBuilder.rest().port(8080).ip(InetAddress.getLoopbackAddress()).routing().add(routeToRest1).add(routeToRest2);
        this.router = new Router(routerConfigurationBuilder.build());
        this.router.start();
        int port = ((EndpointRouter)this.router.getRouter(EndpointRouter.Protocol.REST).get()).getPort();
        RestClient rest1Client = new RestClient("http://127.0.0.1:" + port + "/rest/rest1/v2/caches/").cache("default");
        RestClient rest2Client = new RestClient("http://127.0.0.1:" + port + "/rest/rest2/v2/caches/").cache("default");
        rest1Client.put("test", "rest1");
        rest2Client.put("test", "rest2");
        String valueReturnedFromRest1 = rest1Client.get("test");
        String valueReturnedFromRest2 = rest2Client.get("test");
        Assertions.assertThat((String)valueReturnedFromRest1).isEqualTo((Object)"rest1");
        Assertions.assertThat((String)valueReturnedFromRest2).isEqualTo((Object)"rest2");
    }
}

