/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.router.router.impl.singleport;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import java.util.Map;
import org.infinispan.rest.RestServer;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.transport.NettyChannelInitializer;
import org.infinispan.server.core.transport.NettyTransport;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.router.configuration.SinglePortRouterConfiguration;
import org.infinispan.server.router.router.impl.singleport.HotRodPingDetector;
import org.infinispan.server.router.router.impl.singleport.SinglePortEndpointRouter;
import org.infinispan.server.router.router.impl.singleport.SinglePortUpgradeHandler;

class SinglePortChannelInitializer
extends NettyChannelInitializer {
    private final SinglePortUpgradeHandler httpUpgradeHandler;

    public SinglePortChannelInitializer(SinglePortEndpointRouter server, NettyTransport transport, RestServer restServer, Map<String, ProtocolServer> upgradeServers) {
        super((ProtocolServer)server, transport, null, null);
        this.httpUpgradeHandler = new SinglePortUpgradeHandler(((SinglePortRouterConfiguration)server.getConfiguration()).ssl().enabled(), restServer, upgradeServers);
    }

    public void initializeChannel(Channel ch) throws Exception {
        super.initializeChannel(ch);
        this.httpUpgradeHandler.getUpgradeServers().values().stream().filter(ps -> ps instanceof HotRodServer).findFirst().ifPresent(hotRodServer -> ch.pipeline().addLast("hotrod-ping-detector", (ChannelHandler)new HotRodPingDetector((HotRodServer)hotRodServer)));
        if (this.server.getConfiguration().ssl().enabled()) {
            ch.pipeline().addLast(new ChannelHandler[]{this.httpUpgradeHandler});
        } else {
            this.httpUpgradeHandler.configurePipeline(ch.pipeline(), "http/1.1");
        }
    }

    protected ApplicationProtocolConfig getAlpnConfiguration() {
        return this.httpUpgradeHandler.getAlpnConfiguration();
    }
}

