/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.router.profiling;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.commons.util.Util;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.router.Router;
import org.infinispan.server.router.routes.Route;
import org.infinispan.server.router.routes.RouteDestination;
import org.infinispan.server.router.routes.RouteSource;

public interface PerfTestConfiguration {
    public List<HotRodServer> initServers();

    public RemoteCacheManager initClient(Optional<Router> var1, Optional<Set<Route<? extends RouteSource, ? extends RouteDestination>>> var2, List<HotRodServer> var3);

    default public Optional<Set<Route<? extends RouteSource, ? extends RouteDestination>>> initRoutes(List<HotRodServer> servers) {
        return Optional.empty();
    }

    default public Optional<Router> initRouter(Optional<Set<Route<? extends RouteSource, ? extends RouteDestination>>> routes) {
        return Optional.empty();
    }

    default public void shutdown(List<HotRodServer> servers, Optional<Router> router) {
        servers.forEach(s -> s.stop());
        router.ifPresent(r -> r.stop());
    }

    default public void performLoadTesting(RemoteCacheManager client, int numberOfIterations) {
        String keyPrefix = Util.threadLocalRandomUUID().toString();
        RemoteCache cache = client.getCache();
        IntStream.range(0, numberOfIterations).forEach(i -> cache.put((Object)(keyPrefix + i), (Object)("val" + i)));
    }
}

