/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.router.router.impl.singleport;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.regex.Pattern;
import org.infinispan.server.core.transport.AccessControlFilter;
import org.infinispan.server.resp.RespServer;
import org.infinispan.server.router.logging.RouterLogger;

public class RespDetector
extends ByteToMessageDecoder {
    public static final String NAME = "resp-detector";
    private final RespServer respServer;
    private static final Pattern RESP3_HANDSHAKE = Pattern.compile("^(?s)\\*[1-9]\r\n\\$[1-9]\r\n(HELLO|AUTH)\r\n.*");

    public RespDetector(RespServer respServer) {
        this.respServer = respServer;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        if (in.readableBytes() < 5) {
            return;
        }
        int i = in.readerIndex();
        if (in.getByte(i) == 42) {
            CharSequence handshake = in.getCharSequence(i, in.readableBytes(), StandardCharsets.US_ASCII);
            if (RESP3_HANDSHAKE.matcher(handshake).matches()) {
                this.installRespHandler(ctx);
            } else {
                out.add("-ERR Only RESP3 supported\r\n");
            }
        } else if (in.getCharSequence(i, 5, StandardCharsets.US_ASCII).equals("HELLO")) {
            this.installRespHandler(ctx);
        }
        ctx.pipeline().fireUserEventTriggered((Object)AccessControlFilter.EVENT);
        ctx.pipeline().remove((ChannelHandler)this);
    }

    private void installRespHandler(ChannelHandlerContext ctx) {
        ChannelHandlerAdapter dummyHandler = new ChannelHandlerAdapter(){};
        ctx.pipeline().addAfter(NAME, "dummy", (ChannelHandler)dummyHandler);
        ChannelHandler channelHandler = ctx.pipeline().removeLast();
        while (channelHandler != dummyHandler) {
            channelHandler = ctx.pipeline().removeLast();
        }
        ctx.pipeline().addLast(new ChannelHandler[]{this.respServer.getInitializer()});
        RouterLogger.SERVER.tracef("Detected RESP connection %s", ctx);
    }
}

