package org.infinispan.server.router.logging;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.infinispan.server.router.RoutingTable;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import java.util.Arrays;
import java.lang.IllegalArgumentException;
import java.lang.Exception;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2022-07-13T14:30:23-0400")
public class RouterLogger_$logger extends DelegatingBasicLogger implements RouterLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = RouterLogger_$logger.class.getName();
    public RouterLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String noRouteFound$str() {
        return "ISPN014002: Could not find matching route";
    }
    @Override
    public final IllegalArgumentException noRouteFound() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), noRouteFound$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    @Override
    public final void printOutRoutingTable(final RoutingTable routingTable) {
        super.log.logf(FQCN, INFO, null, printOutRoutingTable$str(), routingTable);
    }
    protected String printOutRoutingTable$str() {
        return "ISPN014005: Routing table: %s";
    }
    protected String configurationValidationError$str() {
        return "ISPN014007: Configuration validation error";
    }
    @Override
    public final IllegalStateException configurationValidationError(final Exception e) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), configurationValidationError$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String hotrodRouterStartFailed$str() {
        return "ISPN014008: Unable to start HotRod router";
    }
    @Override
    public final IllegalStateException hotrodRouterStartFailed(final Exception e) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), hotrodRouterStartFailed$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String restRouterStartFailed$str() {
        return "ISPN014009: Unable to start REST router";
    }
    @Override
    public final IllegalStateException restRouterStartFailed(final Exception e) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), restRouterStartFailed$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void errorWhileShuttingDown(final Exception e) {
        super.log.logf(FQCN, ERROR, e, errorWhileShuttingDown$str());
    }
    protected String errorWhileShuttingDown$str() {
        return "ISPN014010: Error while shutting down the router";
    }
}
