/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.router.integration;

import io.netty.util.CharsetUtil;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.InetAddress;
import java.util.concurrent.CompletionStage;
import org.assertj.core.api.Assertions;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.RemoteCacheContainer;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestEntity;
import org.infinispan.client.rest.configuration.Protocol;
import org.infinispan.client.rest.configuration.RestClientConfiguration;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.UTF8StringMarshaller;
import org.infinispan.commons.test.TestResourceTracker;
import org.infinispan.commons.util.SslContextFactory;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.rest.RestServer;
import org.infinispan.rest.assertion.ResponseAssertion;
import org.infinispan.rest.configuration.RestServerConfigurationBuilder;
import org.infinispan.server.core.DummyServerManagement;
import org.infinispan.server.core.ServerManagement;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.server.router.Router;
import org.infinispan.server.router.configuration.builder.RouterConfigurationBuilder;
import org.infinispan.server.router.router.EndpointRouter;
import org.infinispan.server.router.routes.Route;
import org.infinispan.server.router.routes.RouteDestination;
import org.infinispan.server.router.routes.RouteSource;
import org.infinispan.server.router.routes.hotrod.HotRodServerRouteDestination;
import org.infinispan.server.router.routes.rest.RestServerRouteDestination;
import org.infinispan.server.router.routes.singleport.SinglePortRouteSource;
import org.infinispan.server.router.utils.RestTestingUtil;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.wildfly.openssl.OpenSSLEngine;

public class SinglePortTest {
    public static final String KEY_STORE_PATH = SinglePortTest.class.getClassLoader().getResource("./default_server_keystore.jks").getPath();
    public static final String KEY_STORE_PASSWORD = "secret";
    public static final String TRUST_STORE_PATH = SinglePortTest.class.getClassLoader().getResource("./default_client_truststore.jks").getPath();
    public static final String TRUST_STORE_PASSWORD = "secret";
    public static final RestEntity VALUE = RestEntity.create((MediaType)MediaType.TEXT_PLAIN, (byte[])"test".getBytes(CharsetUtil.UTF_8));
    private Router router;
    private RestServer restServer;
    private HotRodServer hotrodServer;
    private RestClient httpClient;
    private RemoteCacheManager hotRodClient;

    @BeforeClass
    public static void beforeClass() {
        TestResourceTracker.testStarted((String)MethodHandles.lookup().lookupClass().toString());
    }

    @AfterClass
    public static void afterClass() {
        TestResourceTracker.testFinished((String)MethodHandles.lookup().lookupClass().toString());
    }

    @After
    public void afterMethod() throws IOException {
        if (this.httpClient != null) {
            this.httpClient.close();
        }
        HotRodClientTestingUtil.killRemoteCacheManager((RemoteCacheContainer)this.hotRodClient);
        RestTestingUtil.killRouter(this.router);
        HotRodClientTestingUtil.killServers((HotRodServer[])new HotRodServer[]{this.hotrodServer});
        if (this.hotrodServer != null) {
            TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.hotrodServer.getCacheManager()});
        }
        if (this.restServer != null) {
            this.restServer.stop();
            TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.restServer.getCacheManager()});
        }
        this.hotRodClient = null;
        this.hotrodServer = null;
        this.restServer = null;
    }

    @Test
    public void shouldUpgradeThroughHTTP11UpgradeHeaders() {
        this.restServer = RestTestingUtil.createDefaultRestServer("rest", "default");
        RestServerRouteDestination restDestination = new RestServerRouteDestination("rest1", this.restServer);
        SinglePortRouteSource singlePortSource = new SinglePortRouteSource();
        Route routeToRest = new Route((RouteSource)singlePortSource, (RouteDestination)restDestination);
        RouterConfigurationBuilder routerConfigurationBuilder = new RouterConfigurationBuilder();
        routerConfigurationBuilder.singlePort().port(0).ip(InetAddress.getLoopbackAddress()).routing().add(routeToRest);
        this.router = new Router(routerConfigurationBuilder.build());
        this.router.start();
        int port = ((EndpointRouter)this.router.getRouter(EndpointRouter.Protocol.SINGLE_PORT).get()).getPort();
        RestClientConfigurationBuilder builder = new RestClientConfigurationBuilder();
        builder.addServer().host("localhost").port(port).protocol(Protocol.HTTP_20);
        this.httpClient = RestClient.forConfiguration((RestClientConfiguration)builder.build());
        CompletionStage response = this.httpClient.cache("default").post("test", VALUE);
        ResponseAssertion.assertThat((CompletionStage)response).hasNoContent();
    }

    @Test
    public void shouldUpgradeToHotRodThroughHTTP11UpgradeHeaders() {
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration());
        HotRodServerConfigurationBuilder hotRodServerBuilder = new HotRodServerConfigurationBuilder();
        hotRodServerBuilder.startTransport(false);
        hotRodServerBuilder.name(TestResourceTracker.getCurrentTestName());
        this.hotrodServer = HotRodClientTestingUtil.startHotRodServer((EmbeddedCacheManager)cacheManager, (HotRodServerConfigurationBuilder)hotRodServerBuilder);
        this.restServer = new RestServer();
        RestServerConfigurationBuilder restServerConfigurationBuilder = new RestServerConfigurationBuilder();
        restServerConfigurationBuilder.startTransport(false);
        restServerConfigurationBuilder.name(TestResourceTracker.getCurrentTestName());
        this.restServer.setServerManagement((ServerManagement)new DummyServerManagement(), true);
        this.restServer.start((ProtocolServerConfiguration)restServerConfigurationBuilder.build(), cacheManager);
        HotRodServerRouteDestination hotrodDestination = new HotRodServerRouteDestination("hotrod", this.hotrodServer);
        RestServerRouteDestination restDestination = new RestServerRouteDestination("rest", this.restServer);
        SinglePortRouteSource singlePortSource = new SinglePortRouteSource();
        Route routeToHotRod = new Route((RouteSource)singlePortSource, (RouteDestination)hotrodDestination);
        Route routeToRest = new Route((RouteSource)singlePortSource, (RouteDestination)restDestination);
        RouterConfigurationBuilder routerConfigurationBuilder = new RouterConfigurationBuilder();
        routerConfigurationBuilder.singlePort().port(0).ip(InetAddress.getLoopbackAddress()).routing().add(routeToRest).add(routeToHotRod);
        this.router = new Router(routerConfigurationBuilder.build());
        this.router.start();
        EndpointRouter endpointRouter = (EndpointRouter)this.router.getRouter(EndpointRouter.Protocol.SINGLE_PORT).get();
        String host = endpointRouter.getHost();
        int port = endpointRouter.getPort();
        RestClientConfigurationBuilder builder = new RestClientConfigurationBuilder();
        builder.addServer().host(host).port(port).protocol(Protocol.HTTP_11);
        this.httpClient = RestClient.forConfiguration((RestClientConfiguration)builder.build());
        CompletionStage response = this.httpClient.cache((String)cacheManager.getCacheManagerConfiguration().defaultCacheName().get()).post("key", VALUE);
        ResponseAssertion.assertThat((CompletionStage)response).hasNoContent();
        Assertions.assertThat((int)this.restServer.getCacheManager().getCache().size()).isEqualTo(1);
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder();
        configurationBuilder.marshaller((Marshaller)new UTF8StringMarshaller());
        configurationBuilder.addServer().host(host).port(port);
        this.hotRodClient = new RemoteCacheManager(configurationBuilder.build());
        Object value = this.hotRodClient.getCache().withDataFormat(DataFormat.builder().keyType(MediaType.TEXT_PLAIN).valueType(MediaType.TEXT_PLAIN).build()).get((Object)"key");
        Assertions.assertThat((Object)value).isEqualTo((Object)"test");
    }

    @Test
    public void shouldUpgradeThroughALPN() throws Exception {
        this.checkForOpenSSL();
        this.restServer = RestTestingUtil.createDefaultRestServer("rest", "default");
        RestServerRouteDestination restDestination = new RestServerRouteDestination("rest", this.restServer);
        SinglePortRouteSource singlePortSource = new SinglePortRouteSource();
        Route routeToRest = new Route((RouteSource)singlePortSource, (RouteDestination)restDestination);
        SslContextFactory sslContextFactory = new SslContextFactory();
        RouterConfigurationBuilder routerConfigurationBuilder = new RouterConfigurationBuilder();
        routerConfigurationBuilder.singlePort().sslContext(sslContextFactory.keyStoreFileName(KEY_STORE_PATH).keyStorePassword("secret".toCharArray()).getContext()).port(0).ip(InetAddress.getLoopbackAddress()).routing().add(routeToRest);
        this.router = new Router(routerConfigurationBuilder.build());
        this.router.start();
        EndpointRouter singlePortRouter = (EndpointRouter)this.router.getRouter(EndpointRouter.Protocol.SINGLE_PORT).get();
        RestClientConfigurationBuilder builder = new RestClientConfigurationBuilder();
        builder.addServer().host(singlePortRouter.getHost()).port(singlePortRouter.getPort().intValue()).protocol(Protocol.HTTP_20).security().ssl().trustStoreFileName(TRUST_STORE_PATH).trustStorePassword("secret".toCharArray()).hostnameVerifier((hostname, session) -> true);
        this.httpClient = RestClient.forConfiguration((RestClientConfiguration)builder.build());
        CompletionStage response = this.httpClient.cache("default").post("test", VALUE);
        ResponseAssertion.assertThat((CompletionStage)response).hasNoContent();
    }

    @Test
    public void shouldUpgradeToHotRodThroughALPN() {
        this.checkForOpenSSL();
        this.hotrodServer = HotRodTestingUtil.startHotRodServerWithoutTransport((String[])new String[]{"default"});
        this.restServer = RestTestingUtil.createDefaultRestServer("rest", "default");
        HotRodServerRouteDestination hotrodDestination = new HotRodServerRouteDestination("hotrod", this.hotrodServer);
        RestServerRouteDestination restDestination = new RestServerRouteDestination("rest", this.restServer);
        SinglePortRouteSource singlePortSource = new SinglePortRouteSource();
        Route routeToRest = new Route((RouteSource)singlePortSource, (RouteDestination)restDestination);
        Route routeToHotRod = new Route((RouteSource)singlePortSource, (RouteDestination)hotrodDestination);
        SslContextFactory sslContextFactory = new SslContextFactory();
        RouterConfigurationBuilder routerConfigurationBuilder = new RouterConfigurationBuilder();
        routerConfigurationBuilder.singlePort().sslContext(sslContextFactory.keyStoreFileName(KEY_STORE_PATH).keyStorePassword("secret".toCharArray()).getContext()).port(0).ip(InetAddress.getLoopbackAddress()).routing().add(routeToRest).add(routeToHotRod);
        this.router = new Router(routerConfigurationBuilder.build());
        this.router.start();
        EndpointRouter endpointRouter = (EndpointRouter)this.router.getRouter(EndpointRouter.Protocol.SINGLE_PORT).get();
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.addServer().host(endpointRouter.getIp().getHostAddress()).port(endpointRouter.getPort().intValue());
        builder.security().ssl().trustStoreFileName(TRUST_STORE_PATH).trustStorePassword("secret".toCharArray());
        this.hotRodClient = new RemoteCacheManager(builder.build());
        this.hotRodClient.getCache("default").put((Object)"test", (Object)"test");
    }

    private void checkForOpenSSL() {
        if (!OpenSSLEngine.isAlpnSupported()) {
            throw new IllegalStateException("OpenSSL is not present, can not test TLS/ALPN support.");
        }
    }
}

