/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.router.integration;

import java.net.InetAddress;
import org.assertj.core.api.Assertions;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.server.router.MultiTenantRouter;
import org.infinispan.server.router.configuration.builder.MultiTenantRouterConfigurationBuilder;
import org.infinispan.server.router.router.Router;
import org.infinispan.server.router.routes.Route;
import org.infinispan.server.router.routes.RouteDestination;
import org.infinispan.server.router.routes.RouteSource;
import org.infinispan.server.router.routes.hotrod.NettyHandlerRouteDestination;
import org.infinispan.server.router.routes.hotrod.SniNettyRouteSource;
import org.infinispan.server.router.utils.HotRodClientTestingUtil;
import org.infinispan.test.fwk.TestResourceTracker;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class HotRodRouterTest {
    private final String KEYSTORE_LOCATION_FOR_HOTROD_1 = this.getClass().getClassLoader().getResource("sni_server_keystore.jks").getPath();
    private final String TRUSTSTORE_LOCATION_FOR_HOTROD_1 = this.getClass().getClassLoader().getResource("sni_client_truststore.jks").getPath();
    private final String KEYSTORE_LOCATION_FOR_HOTROD_2 = this.getClass().getClassLoader().getResource("default_server_keystore.jks").getPath();
    private final String TRUSTSTORE_LOCATION_FOR_HOTROD_2 = this.getClass().getClassLoader().getResource("default_client_truststore.jks").getPath();

    @BeforeClass
    public static void beforeClass() {
        TestResourceTracker.testStarted((String)HotRodRouterTest.class.getName());
    }

    @AfterClass
    public static void afterClass() {
        TestResourceTracker.testFinished((String)HotRodRouterTest.class.getName());
    }

    @Test
    public void shouldRouteToProperHotRodServerBasedOnSniHostName() throws Exception {
        HotRodServer hotrodServer1 = HotRodTestingUtil.startHotRodServerWithoutTransport();
        HotRodServer hotrodServer2 = HotRodTestingUtil.startHotRodServerWithoutTransport();
        NettyHandlerRouteDestination hotrod1Destination = new NettyHandlerRouteDestination("HotRod1", hotrodServer1.getInitializer());
        SniNettyRouteSource hotrod1Source = new SniNettyRouteSource("hotrod1", this.KEYSTORE_LOCATION_FOR_HOTROD_1, "secret".toCharArray());
        Route routeToHotrod1 = new Route((RouteSource)hotrod1Source, (RouteDestination)hotrod1Destination);
        NettyHandlerRouteDestination hotrod2Destination = new NettyHandlerRouteDestination("HotRod2", hotrodServer2.getInitializer());
        SniNettyRouteSource hotrod2Source = new SniNettyRouteSource("hotrod2", this.KEYSTORE_LOCATION_FOR_HOTROD_2, "secret".toCharArray());
        Route routeToHotrod2 = new Route((RouteSource)hotrod2Source, (RouteDestination)hotrod2Destination);
        MultiTenantRouterConfigurationBuilder routerConfigurationBuilder = new MultiTenantRouterConfigurationBuilder();
        routerConfigurationBuilder.hotrod().port(0).ip(InetAddress.getLoopbackAddress()).routing().add(routeToHotrod1).add(routeToHotrod2);
        MultiTenantRouter router = new MultiTenantRouter(routerConfigurationBuilder.build());
        router.start();
        InetAddress routerIp = (InetAddress)((Router)router.getRouter(Router.Protocol.HOT_ROD).get()).getIp().get();
        int routerPort = (Integer)((Router)router.getRouter(Router.Protocol.HOT_ROD).get()).getPort().get();
        RemoteCacheManager hotrod1Client = HotRodClientTestingUtil.createWithSni(routerIp, routerPort, "hotrod1", this.TRUSTSTORE_LOCATION_FOR_HOTROD_1, "secret".toCharArray());
        RemoteCacheManager hotrod2Client = HotRodClientTestingUtil.createWithSni(routerIp, routerPort, "hotrod2", this.TRUSTSTORE_LOCATION_FOR_HOTROD_2, "secret".toCharArray());
        hotrod1Client.getCache().put((Object)"test", (Object)"hotrod1");
        hotrod2Client.getCache().put((Object)"test", (Object)"hotrod2");
        Cache hotrod1Cache = hotrodServer1.getCacheManager().getCache();
        Cache hotrod2Cache = hotrodServer2.getCacheManager().getCache();
        Assertions.assertThat((int)hotrod1Cache.size()).isEqualTo(1);
        Assertions.assertThat((int)hotrod2Cache.size()).isEqualTo(1);
        Assertions.assertThat((String)((String)hotrod1Cache.get((Object)"test"))).isEqualTo((Object)"hotrod1");
        Assertions.assertThat((String)((String)hotrod2Cache.get((Object)"test"))).isEqualTo((Object)"hotrod2");
    }
}

