/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.router.integration;

import java.net.InetAddress;
import org.assertj.core.api.Assertions;
import org.infinispan.rest.embedded.netty4.NettyRestServer;
import org.infinispan.server.router.MultiTenantRouter;
import org.infinispan.server.router.configuration.builder.MultiTenantRouterConfigurationBuilder;
import org.infinispan.server.router.routes.Route;
import org.infinispan.server.router.routes.RouteDestination;
import org.infinispan.server.router.routes.RouteSource;
import org.infinispan.server.router.routes.rest.NettyRestServerRouteDestination;
import org.infinispan.server.router.routes.rest.RestRouteSource;
import org.infinispan.server.router.utils.RestClient;
import org.infinispan.server.router.utils.RestTestingUtil;
import org.junit.Test;

public class RestRouterTest {
    @Test
    public void shouldRouteToProperRestServerBasedOnPath() throws Exception {
        NettyRestServer restServer1 = RestTestingUtil.createDefaultRestServer();
        NettyRestServer restServer2 = RestTestingUtil.createDefaultRestServer();
        NettyRestServerRouteDestination rest1Destination = new NettyRestServerRouteDestination("rest1", restServer1.getServer());
        RestRouteSource rest1Source = new RestRouteSource("rest1");
        Route routeToRest1 = new Route((RouteSource)rest1Source, (RouteDestination)rest1Destination);
        NettyRestServerRouteDestination rest2Destination = new NettyRestServerRouteDestination("rest2", restServer2.getServer());
        RestRouteSource rest2Source = new RestRouteSource("rest2");
        Route routeToRest2 = new Route((RouteSource)rest2Source, (RouteDestination)rest2Destination);
        MultiTenantRouterConfigurationBuilder routerConfigurationBuilder = new MultiTenantRouterConfigurationBuilder();
        routerConfigurationBuilder.rest().port(8080).ip(InetAddress.getLoopbackAddress()).routing().add(routeToRest1).add(routeToRest2);
        MultiTenantRouter router = new MultiTenantRouter(routerConfigurationBuilder.build());
        router.start();
        RestClient rest1Client = new RestClient("http://127.0.0.1:8080/rest/rest1");
        RestClient rest2Client = new RestClient("http://127.0.0.1:8080/rest/rest2");
        rest1Client.put("test", "rest1");
        rest2Client.put("test", "rest2");
        String valueReturnedFromRest1 = rest1Client.get("test");
        String valueReturnedFromRest2 = rest2Client.get("test");
        Assertions.assertThat((String)valueReturnedFromRest1).isEqualTo((Object)"rest1");
        Assertions.assertThat((String)valueReturnedFromRest2).isEqualTo((Object)"rest2");
    }
}

