/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.router.configuration.builder;

import java.lang.invoke.MethodHandles;
import java.net.InetAddress;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.server.router.configuration.builder.HotRodRouterBuilder;
import org.infinispan.server.router.configuration.builder.MultiTenantConfigurationBuilderParent;
import org.infinispan.server.router.configuration.builder.RestRouterBuilder;
import org.infinispan.server.router.configuration.builder.RoutingBuilder;
import org.infinispan.server.router.logging.RouterLogger;

public abstract class AbstractRouterBuilder
implements MultiTenantConfigurationBuilderParent {
    protected static final RouterLogger logger = (RouterLogger)LogFactory.getLog(MethodHandles.lookup().lookupClass(), RouterLogger.class);
    protected final MultiTenantConfigurationBuilderParent parent;
    protected int port;
    protected InetAddress ip;
    protected boolean enabled;

    protected AbstractRouterBuilder(MultiTenantConfigurationBuilderParent parent) {
        this.parent = parent;
    }

    public AbstractRouterBuilder port(int port) {
        this.port = port;
        return this;
    }

    public AbstractRouterBuilder ip(InetAddress ip) {
        this.ip = ip;
        return this;
    }

    public AbstractRouterBuilder enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    protected void validate() {
        if (this.enabled) {
            if (this.ip == null) {
                throw new IllegalArgumentException("IP can not be null");
            }
            if (this.port < 0) {
                throw new IllegalArgumentException("Port can not be negative");
            }
        }
    }

    @Override
    public RoutingBuilder routing() {
        return this.parent.routing();
    }

    @Override
    public HotRodRouterBuilder hotrod() {
        return this.parent.hotrod();
    }

    @Override
    public RestRouterBuilder rest() {
        return this.parent.rest();
    }
}

