/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.router.configuration.builder;

import org.infinispan.server.router.configuration.HotRodRouterConfiguration;
import org.infinispan.server.router.configuration.builder.AbstractRouterBuilder;
import org.infinispan.server.router.configuration.builder.MultiTenantConfigurationBuilderParent;

public class HotRodRouterBuilder
extends AbstractRouterBuilder {
    private int sendBufferSize = 0;
    private int receiveBufferSize = 0;
    private boolean keepAlive = false;
    private boolean tcpNoDelay = true;

    public HotRodRouterBuilder(MultiTenantConfigurationBuilderParent parent) {
        super(parent);
    }

    public HotRodRouterConfiguration build() {
        if (this.enabled) {
            try {
                this.validate();
            }
            catch (Exception e) {
                throw logger.configurationValidationError(e);
            }
            return new HotRodRouterConfiguration(this.ip, this.port, this.sendBufferSize, this.receiveBufferSize, this.keepAlive, this.tcpNoDelay);
        }
        return null;
    }

    public HotRodRouterBuilder tcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
        return this;
    }

    public HotRodRouterBuilder keepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
        return this;
    }

    public HotRodRouterBuilder sendBufferSize(int sendBufferSize) {
        this.sendBufferSize = sendBufferSize;
        return this;
    }

    public HotRodRouterBuilder receiveBufferSize(int receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
        return this;
    }

    @Override
    protected void validate() {
        super.validate();
        if (this.receiveBufferSize < 0) {
            throw new IllegalArgumentException("Receive buffer size can not be negative");
        }
        if (this.sendBufferSize < 0) {
            throw new IllegalArgumentException("Send buffer size can not be negative");
        }
    }
}

