/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.router.integration;

import java.net.InetAddress;
import org.assertj.core.api.Assertions;
import org.infinispan.AdvancedCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.commons.dataconversion.GenericJbossMarshallerEncoder;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.server.router.Router;
import org.infinispan.server.router.configuration.builder.RouterConfigurationBuilder;
import org.infinispan.server.router.router.EndpointRouter;
import org.infinispan.server.router.routes.Route;
import org.infinispan.server.router.routes.RouteDestination;
import org.infinispan.server.router.routes.RouteSource;
import org.infinispan.server.router.routes.hotrod.HotRodServerRouteDestination;
import org.infinispan.server.router.routes.hotrod.SniNettyRouteSource;
import org.infinispan.server.router.utils.HotRodClientTestingUtil;
import org.infinispan.test.fwk.TestResourceTracker;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class ProtocolServerEndpointRouterTest {
    private final String KEYSTORE_LOCATION_FOR_HOTROD_1 = this.getClass().getClassLoader().getResource("sni_server_keystore.jks").getPath();
    private final String TRUSTSTORE_LOCATION_FOR_HOTROD_1 = this.getClass().getClassLoader().getResource("sni_client_truststore.jks").getPath();
    private final String KEYSTORE_LOCATION_FOR_HOTROD_2 = this.getClass().getClassLoader().getResource("default_server_keystore.jks").getPath();
    private final String TRUSTSTORE_LOCATION_FOR_HOTROD_2 = this.getClass().getClassLoader().getResource("default_client_truststore.jks").getPath();

    @BeforeClass
    public static void beforeClass() {
        TestResourceTracker.testStarted((String)ProtocolServerEndpointRouterTest.class.getName());
    }

    @AfterClass
    public static void afterClass() {
        TestResourceTracker.testFinished((String)ProtocolServerEndpointRouterTest.class.getName());
    }

    @Test
    public void shouldRouteToProperHotRodServerBasedOnSniHostName() throws Exception {
        HotRodServer hotrodServer1 = HotRodTestingUtil.startHotRodServerWithoutTransport((String[])new String[0]);
        HotRodServer hotrodServer2 = HotRodTestingUtil.startHotRodServerWithoutTransport((String[])new String[0]);
        HotRodServerRouteDestination hotrod1Destination = new HotRodServerRouteDestination("HotRod1", hotrodServer1);
        SniNettyRouteSource hotrod1Source = new SniNettyRouteSource("hotrod1", this.KEYSTORE_LOCATION_FOR_HOTROD_1, "secret".toCharArray());
        Route routeToHotrod1 = new Route((RouteSource)hotrod1Source, (RouteDestination)hotrod1Destination);
        HotRodServerRouteDestination hotrod2Destination = new HotRodServerRouteDestination("HotRod2", hotrodServer2);
        SniNettyRouteSource hotrod2Source = new SniNettyRouteSource("hotrod2", this.KEYSTORE_LOCATION_FOR_HOTROD_2, "secret".toCharArray());
        Route routeToHotrod2 = new Route((RouteSource)hotrod2Source, (RouteDestination)hotrod2Destination);
        RouterConfigurationBuilder routerConfigurationBuilder = new RouterConfigurationBuilder();
        routerConfigurationBuilder.hotrod().port(0).ip(InetAddress.getLoopbackAddress()).routing().add(routeToHotrod1).add(routeToHotrod2);
        Router router = new Router(routerConfigurationBuilder.build());
        router.start();
        InetAddress routerIp = ((EndpointRouter)router.getRouter(EndpointRouter.Protocol.HOT_ROD).get()).getIp();
        int routerPort = ((EndpointRouter)router.getRouter(EndpointRouter.Protocol.HOT_ROD).get()).getPort();
        RemoteCacheManager hotrod1Client = HotRodClientTestingUtil.createWithSni(routerIp, routerPort, "hotrod1", this.TRUSTSTORE_LOCATION_FOR_HOTROD_1, "secret".toCharArray());
        RemoteCacheManager hotrod2Client = HotRodClientTestingUtil.createWithSni(routerIp, routerPort, "hotrod2", this.TRUSTSTORE_LOCATION_FOR_HOTROD_2, "secret".toCharArray());
        hotrod1Client.getCache().put((Object)"test", (Object)"hotrod1");
        hotrod2Client.getCache().put((Object)"test", (Object)"hotrod2");
        AdvancedCache hotrod1Cache = hotrodServer1.getCacheManager().getCache().getAdvancedCache().withEncoding(GenericJbossMarshallerEncoder.class);
        AdvancedCache hotrod2Cache = hotrodServer2.getCacheManager().getCache().getAdvancedCache().withEncoding(GenericJbossMarshallerEncoder.class);
        Assertions.assertThat((int)hotrod1Cache.size()).isEqualTo(1);
        Assertions.assertThat((int)hotrod2Cache.size()).isEqualTo(1);
        Assertions.assertThat((Object)hotrod1Cache.get((Object)"test")).isEqualTo((Object)"hotrod1");
        Assertions.assertThat((Object)hotrod2Cache.get((Object)"test")).isEqualTo((Object)"hotrod2");
    }
}

