/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.router.router.impl.hotrod;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.Future;
import java.lang.invoke.MethodHandles;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadFactory;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.server.router.RoutingTable;
import org.infinispan.server.router.configuration.HotRodRouterConfiguration;
import org.infinispan.server.router.logging.RouterLogger;
import org.infinispan.server.router.router.EndpointRouter;
import org.infinispan.server.router.router.impl.hotrod.handlers.SniHandlerInitializer;

public class HotRodEndpointRouter
implements EndpointRouter {
    private static final RouterLogger logger = (RouterLogger)LogFactory.getLog(MethodHandles.lookup().lookupClass(), RouterLogger.class);
    private static final String THREAD_NAME_PREFIX = "EndpointRouter";
    private final NioEventLoopGroup masterGroup = new NioEventLoopGroup(1, (ThreadFactory)new DefaultThreadFactory("EndpointRouter-ServerMaster"));
    private final NioEventLoopGroup workerGroup = new NioEventLoopGroup(0, (ThreadFactory)new DefaultThreadFactory("EndpointRouter-ServerWorker"));
    private final HotRodRouterConfiguration configuration;
    private Integer port = null;
    private InetAddress ip = null;

    public HotRodEndpointRouter(HotRodRouterConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void start(RoutingTable routingTable) {
        try {
            ServerBootstrap bootstrap = new ServerBootstrap();
            bootstrap.group((EventLoopGroup)this.masterGroup, (EventLoopGroup)this.workerGroup).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT).childOption(ChannelOption.TCP_NODELAY, (Object)this.configuration.tcpNoDelay()).childOption(ChannelOption.SO_KEEPALIVE, (Object)this.configuration.tcpKeepAlive()).childHandler((ChannelHandler)new SniHandlerInitializer(routingTable)).channel(NioServerSocketChannel.class);
            if (this.configuration.sendBufferSize() > 0) {
                bootstrap.childOption(ChannelOption.SO_SNDBUF, (Object)this.configuration.sendBufferSize());
            }
            if (this.configuration.receiveBufferSize() > 0) {
                bootstrap.childOption(ChannelOption.SO_RCVBUF, (Object)this.configuration.receiveBufferSize());
            }
            InetAddress ip = this.configuration.getIp();
            int port = this.configuration.getPort();
            Channel channel = bootstrap.bind(ip, port).sync().channel();
            InetSocketAddress localAddress = (InetSocketAddress)channel.localAddress();
            this.port = localAddress.getPort();
            this.ip = localAddress.getAddress();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            throw logger.hotrodRouterStartFailed(e);
        }
        logger.hotRodRouterStarted(this.ip + ":" + this.port);
    }

    @Override
    public void stop() {
        CompletableFuture masterGroupShutdown = this.wrapShutdownFuture(this.masterGroup.shutdownGracefully());
        CompletableFuture workerGroupShutdown = this.wrapShutdownFuture(this.workerGroup.shutdownGracefully());
        try {
            CompletableFuture.allOf(masterGroupShutdown, workerGroupShutdown).get();
        }
        catch (Exception e) {
            logger.errorWhileShuttingDown(e);
        }
        this.port = null;
        this.ip = null;
    }

    @Override
    public InetAddress getIp() {
        return this.ip;
    }

    @Override
    public Integer getPort() {
        return this.port;
    }

    private <U> CompletableFuture<U> wrapShutdownFuture(Future<U> shutdownFuture) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return shutdownFuture.get();
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        });
    }

    @Override
    public EndpointRouter.Protocol getProtocol() {
        return EndpointRouter.Protocol.HOT_ROD;
    }
}

