/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.router.logging;

import io.netty.util.DomainNameMapping;
import org.infinispan.server.router.RoutingTable;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="ISPN")
public interface RouterLogger
extends BasicLogger {
    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Using SNI Handler with domain mapping %s", id=14001)
    public void initializedSni(DomainNameMapping var1);

    @Message(value="Could not find matching route", id=14002)
    public IllegalArgumentException noRouteFound();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="HotRod EndpointRouter listening on %s", id=14003)
    public void hotRodRouterStarted(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="REST EndpointRouter listening on %s", id=14004)
    public void restRouterStarted(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Routing table: %s", id=14005)
    public void printOutRoutingTable(RoutingTable var1);

    @Message(value="Configuration validation error", id=14007)
    public IllegalStateException configurationValidationError(@Cause Exception var1);

    @Message(value="Unable to start HotRod router", id=14008)
    public IllegalStateException hotrodRouterStartFailed(@Cause Exception var1);

    @Message(value="Unable to start REST router", id=14009)
    public IllegalStateException restRouterStartFailed(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error while shutting down the router", id=14010)
    public void errorWhileShuttingDown(@Cause Exception var1);
}

