/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.router.integration;

import java.net.InetAddress;
import org.assertj.core.api.Assertions;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.server.router.Router;
import org.infinispan.server.router.configuration.builder.RouterConfigurationBuilder;
import org.infinispan.server.router.router.EndpointRouter;
import org.infinispan.server.router.routes.Route;
import org.infinispan.server.router.routes.RouteDestination;
import org.infinispan.server.router.routes.RouteSource;
import org.infinispan.server.router.routes.hotrod.HotRodServerRouteDestination;
import org.infinispan.server.router.routes.hotrod.SniNettyRouteSource;
import org.infinispan.server.router.utils.HotRodClientTestingUtil;
import org.infinispan.test.fwk.TestResourceTracker;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class ProtocolServerEndpointRouterTest {
    private final String KEYSTORE_LOCATION_FOR_HOTROD_1 = this.getClass().getClassLoader().getResource("sni_server_keystore.jks").getPath();
    private final String TRUSTSTORE_LOCATION_FOR_HOTROD_1 = this.getClass().getClassLoader().getResource("sni_client_truststore.jks").getPath();
    private final String KEYSTORE_LOCATION_FOR_HOTROD_2 = this.getClass().getClassLoader().getResource("default_server_keystore.jks").getPath();
    private final String TRUSTSTORE_LOCATION_FOR_HOTROD_2 = this.getClass().getClassLoader().getResource("default_client_truststore.jks").getPath();
    private HotRodServer hotrodServer1;
    private HotRodServer hotrodServer2;
    private Router router;
    private RemoteCacheManager hotrod1Client;
    private RemoteCacheManager hotrod2Client;

    @BeforeClass
    public static void beforeClass() {
        TestResourceTracker.testStarted((String)ProtocolServerEndpointRouterTest.class.getName());
    }

    @AfterClass
    public static void afterClass() {
        TestResourceTracker.testFinished((String)ProtocolServerEndpointRouterTest.class.getName());
    }

    @After
    public void afterMethod() {
        if (this.router != null) {
            this.router.stop();
        }
        if (this.hotrodServer1 != null) {
            this.hotrodServer1.stop();
            this.hotrodServer1.getCacheManager().stop();
        }
        if (this.hotrodServer2 != null) {
            this.hotrodServer2.stop();
            this.hotrodServer2.getCacheManager().stop();
        }
        if (this.hotrod1Client != null) {
            this.hotrod1Client.stop();
        }
        if (this.hotrod2Client != null) {
            this.hotrod2Client.stop();
        }
    }

    @Test
    public void shouldRouteToProperHotRodServerBasedOnSniHostName() throws Exception {
        this.hotrodServer1 = HotRodTestingUtil.startHotRodServerWithoutTransport((String[])new String[0]);
        this.hotrodServer2 = HotRodTestingUtil.startHotRodServerWithoutTransport((String[])new String[0]);
        HotRodServerRouteDestination hotrod1Destination = new HotRodServerRouteDestination("HotRod1", this.hotrodServer1);
        SniNettyRouteSource hotrod1Source = new SniNettyRouteSource("hotrod1", this.KEYSTORE_LOCATION_FOR_HOTROD_1, "secret".toCharArray());
        Route routeToHotrod1 = new Route((RouteSource)hotrod1Source, (RouteDestination)hotrod1Destination);
        HotRodServerRouteDestination hotrod2Destination = new HotRodServerRouteDestination("HotRod2", this.hotrodServer2);
        SniNettyRouteSource hotrod2Source = new SniNettyRouteSource("hotrod2", this.KEYSTORE_LOCATION_FOR_HOTROD_2, "secret".toCharArray());
        Route routeToHotrod2 = new Route((RouteSource)hotrod2Source, (RouteDestination)hotrod2Destination);
        RouterConfigurationBuilder routerConfigurationBuilder = new RouterConfigurationBuilder();
        routerConfigurationBuilder.hotrod().port(0).ip(InetAddress.getLoopbackAddress()).routing().add(routeToHotrod1).add(routeToHotrod2);
        this.router = new Router(routerConfigurationBuilder.build());
        this.router.start();
        InetAddress routerIp = ((EndpointRouter)this.router.getRouter(EndpointRouter.Protocol.HOT_ROD).get()).getIp();
        int routerPort = ((EndpointRouter)this.router.getRouter(EndpointRouter.Protocol.HOT_ROD).get()).getPort();
        this.hotrod1Client = HotRodClientTestingUtil.createWithSni(routerIp, routerPort, "hotrod1", this.TRUSTSTORE_LOCATION_FOR_HOTROD_1, "secret".toCharArray());
        this.hotrod2Client = HotRodClientTestingUtil.createWithSni(routerIp, routerPort, "hotrod2", this.TRUSTSTORE_LOCATION_FOR_HOTROD_2, "secret".toCharArray());
        this.hotrod1Client.getCache().put((Object)"test", (Object)"hotrod1");
        this.hotrod2Client.getCache().put((Object)"test", (Object)"hotrod2");
        Cache hotrod1Cache = this.hotrodServer1.getCacheManager().getCache();
        Cache hotrod2Cache = this.hotrodServer2.getCacheManager().getCache();
        Assertions.assertThat((int)hotrod1Cache.size()).isEqualTo(1);
        Assertions.assertThat((int)hotrod2Cache.size()).isEqualTo(1);
        Assertions.assertThat((String)((String)hotrod1Cache.get((Object)"test"))).isEqualTo((Object)"hotrod1");
        Assertions.assertThat((String)((String)hotrod2Cache.get((Object)"test"))).isEqualTo((Object)"hotrod2");
    }
}

