/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.router;

import java.lang.invoke.MethodHandles;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.server.router.configuration.RouterConfiguration;
import org.infinispan.server.router.logging.RouterLogger;
import org.infinispan.server.router.router.EndpointRouter;
import org.infinispan.server.router.router.impl.hotrod.HotRodEndpointRouter;
import org.infinispan.server.router.router.impl.rest.RestEndpointRouter;
import org.infinispan.server.router.router.impl.singleport.SinglePortEndpointRouter;

public class Router {
    private static final RouterLogger logger = (RouterLogger)LogFactory.getLog(MethodHandles.lookup().lookupClass(), RouterLogger.class);
    private final RouterConfiguration routerConfiguration;
    private final Set<EndpointRouter> endpointRouters = new HashSet<EndpointRouter>();

    public Router(RouterConfiguration routerConfiguration) {
        this.routerConfiguration = routerConfiguration;
        if (routerConfiguration.getHotRodRouterConfiguration() != null) {
            this.endpointRouters.add(new HotRodEndpointRouter(routerConfiguration.getHotRodRouterConfiguration()));
        }
        if (routerConfiguration.getRestRouterConfiguration() != null) {
            this.endpointRouters.add(new RestEndpointRouter(routerConfiguration.getRestRouterConfiguration()));
        }
        if (routerConfiguration.getSinglePortRouterConfiguration() != null) {
            this.endpointRouters.add(new SinglePortEndpointRouter(routerConfiguration.getSinglePortRouterConfiguration()));
        }
    }

    public void start() {
        this.endpointRouters.forEach(r -> r.start(this.routerConfiguration.getRoutingTable()));
        logger.printOutRoutingTable(this.routerConfiguration.getRoutingTable());
    }

    public void stop() {
        this.endpointRouters.forEach(r -> r.stop());
    }

    public Optional<EndpointRouter> getRouter(EndpointRouter.Protocol protocol) {
        return this.endpointRouters.stream().filter(r -> r.getProtocol() == protocol).findFirst();
    }
}

