/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration;

import java.io.File;
import java.util.LinkedHashMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.internal.PrivateGlobalConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.Namespaces;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.configuration.parsing.ParserScope;
import org.infinispan.configuration.parsing.XMLExtendedStreamReader;
import org.infinispan.server.configuration.Attribute;
import org.infinispan.server.configuration.Element;
import org.infinispan.server.configuration.ServerConfigurationBuilder;
import org.infinispan.server.network.NetworkAddress;
import org.infinispan.server.security.PropertiesSecurityRealm;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.wildfly.security.auth.server.SecurityRealm;

@Namespaces(value={@Namespace(root="server"), @Namespace(uri="urn:infinispan:server:*", root="server")})
public class ServerConfigurationParser
implements ConfigurationParser {
    private static Log coreLog = LogFactory.getLog(ServerConfigurationParser.class);
    public static String ENDPOINTS_SCOPE = "ENDPOINTS";

    public Namespace[] getNamespaces() {
        return ParseUtils.getNamespaceAnnotations(this.getClass());
    }

    public static Element nextElement(XMLStreamReader reader) throws XMLStreamException {
        if (reader.nextTag() == 2) {
            return null;
        }
        return Element.forName(reader.getLocalName());
    }

    public void readElement(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        if (!holder.inScope((Enum)ParserScope.GLOBAL)) {
            throw coreLog.invalidScope(ParserScope.GLOBAL.name(), holder.getScope());
        }
        GlobalConfigurationBuilder builder = holder.getGlobalConfigurationBuilder();
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case SERVER: {
                ((PrivateGlobalConfigurationBuilder)builder.addModule(PrivateGlobalConfigurationBuilder.class)).serverMode(true);
                ServerConfigurationBuilder serverConfigurationBuilder = (ServerConfigurationBuilder)builder.addModule(ServerConfigurationBuilder.class);
                this.parseServerElements(reader, holder, serverConfigurationBuilder);
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
            }
        }
    }

    private void parseServerElements(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder, ServerConfigurationBuilder builder) throws XMLStreamException {
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case INTERFACES: {
                    this.parseInterfaces(reader, builder);
                    continue block6;
                }
                case SOCKET_BINDINGS: {
                    this.parseSocketBindings(reader, builder);
                    continue block6;
                }
                case SECURITY: {
                    this.parseSecurity(reader, builder);
                    continue block6;
                }
                case ENDPOINTS: {
                    this.parseEndpoints(reader, holder);
                    continue block6;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }

    private void parseSocketBindings(XMLExtendedStreamReader reader, ServerConfigurationBuilder builder) throws XMLStreamException {
        String[] attributes = ParseUtils.requireAttributes((XMLStreamReader)reader, (Enum[])new Enum[]{Attribute.DEFAULT_INTERFACE, Attribute.PORT_OFFSET});
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case SOCKET_BINDING: {
                    this.parseSocketBinding(reader, builder, attributes[0], Integer.parseInt(attributes[1]));
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }

    private void parseSocketBinding(XMLExtendedStreamReader reader, ServerConfigurationBuilder builder, String defaultInterfaceName, int portOffset) throws XMLStreamException {
        String[] attributes = ParseUtils.requireAttributes((XMLStreamReader)reader, (Enum[])new Enum[]{Attribute.NAME, Attribute.PORT});
        String name = attributes[0];
        int port = Integer.parseInt(attributes[1]);
        String interfaceName = defaultInterfaceName;
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: 
                case PORT: {
                    continue block4;
                }
                case INTERFACE: {
                    interfaceName = value;
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
        builder.addSocketBinding(name, interfaceName, port + portOffset);
    }

    private void parseInterfaces(XMLExtendedStreamReader reader, ServerConfigurationBuilder builder) throws XMLStreamException {
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case INTERFACE: {
                    this.parseInterface(reader, builder);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }

    private void parseInterface(XMLExtendedStreamReader reader, ServerConfigurationBuilder builder) throws XMLStreamException {
        String[] attributes = ParseUtils.requireAttributes((XMLStreamReader)reader, (Enum[])new Enum[]{Attribute.NAME});
        String name = attributes[0];
        Element element = ServerConfigurationParser.nextElement((XMLStreamReader)reader);
        if (element == null) {
            throw ParseUtils.unexpectedEndElement((XMLStreamReader)reader);
        }
        switch (element) {
            case INET_ADDRESS: {
                ParseUtils.requireNoContent((XMLStreamReader)reader);
                builder.addNetworkInterface(NetworkAddress.inetAddress(name, ParseUtils.requireSingleAttribute((XMLStreamReader)reader, (Enum)Attribute.VALUE)));
                break;
            }
            case LINK_LOCAL: {
                ParseUtils.requireNoAttributes((XMLStreamReader)reader);
                ParseUtils.requireNoContent((XMLStreamReader)reader);
                builder.addNetworkInterface(NetworkAddress.linkLocalAddress(name));
                break;
            }
            case GLOBAL: {
                ParseUtils.requireNoAttributes((XMLStreamReader)reader);
                ParseUtils.requireNoContent((XMLStreamReader)reader);
                builder.addNetworkInterface(NetworkAddress.globalAddress(name));
                break;
            }
            case LOOPBACK: {
                ParseUtils.requireNoAttributes((XMLStreamReader)reader);
                ParseUtils.requireNoContent((XMLStreamReader)reader);
                builder.addNetworkInterface(NetworkAddress.loopback(name));
                break;
            }
            case NON_LOOPBACK: {
                ParseUtils.requireNoAttributes((XMLStreamReader)reader);
                ParseUtils.requireNoContent((XMLStreamReader)reader);
                builder.addNetworkInterface(NetworkAddress.nonLoopback(name));
                break;
            }
            case SITE_LOCAL: {
                ParseUtils.requireNoAttributes((XMLStreamReader)reader);
                ParseUtils.requireNoContent((XMLStreamReader)reader);
                builder.addNetworkInterface(NetworkAddress.siteLocal(name));
                break;
            }
            case MATCH_INTERFACE: {
                ParseUtils.requireNoContent((XMLStreamReader)reader);
                builder.addNetworkInterface(NetworkAddress.matchInterface(name, ParseUtils.requireSingleAttribute((XMLStreamReader)reader, (Enum)Attribute.VALUE)));
                break;
            }
            case MATCH_ADDRESS: {
                ParseUtils.requireNoContent((XMLStreamReader)reader);
                builder.addNetworkInterface(NetworkAddress.matchAddress(name, ParseUtils.requireSingleAttribute((XMLStreamReader)reader, (Enum)Attribute.VALUE)));
                break;
            }
            case MATCH_HOST: {
                ParseUtils.requireNoContent((XMLStreamReader)reader);
                builder.addNetworkInterface(NetworkAddress.matchHost(name, ParseUtils.requireSingleAttribute((XMLStreamReader)reader, (Enum)Attribute.VALUE)));
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    private void parseSecurity(XMLExtendedStreamReader reader, ServerConfigurationBuilder builder) throws XMLStreamException {
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case SECURITY_REALMS: {
                    this.parseSecurityRealms(reader, builder);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }

    private void parseSecurityRealms(XMLExtendedStreamReader reader, ServerConfigurationBuilder builder) throws XMLStreamException {
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case SECURITY_REALM: {
                    this.parseSecurityRealm(reader, builder);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }

    private void parseSecurityRealm(XMLExtendedStreamReader reader, ServerConfigurationBuilder builder) throws XMLStreamException {
        String name = ParseUtils.requireSingleAttribute((XMLStreamReader)reader, (Enum)Attribute.NAME);
        LinkedHashMap subRealms = new LinkedHashMap();
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case KERBEROS_REALM: {
                    SecurityRealm realm = this.parseKerberosRealm(reader, builder);
                    continue block7;
                }
                case LOCAL_REALM: {
                    SecurityRealm realm = this.parseLocalRealm(reader, builder);
                    continue block7;
                }
                case PROPERTIES_REALM: {
                    SecurityRealm realm = this.parsePropertiesRealm(reader, name);
                    continue block7;
                }
                case SERVER_IDENTITIES: {
                    this.parseServerIdentitities(reader, builder);
                    continue block7;
                }
                case TRUSTSTORE_REALM: {
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }

    private SecurityRealm parseKerberosRealm(XMLExtendedStreamReader reader, ServerConfigurationBuilder builder) throws XMLStreamException {
        String keyTab = ParseUtils.requireAttributes((XMLStreamReader)reader, (Enum[])new Enum[]{Attribute.KEYTAB})[0];
        ParseUtils.requireNoContent((XMLStreamReader)reader);
        return null;
    }

    private SecurityRealm parseLocalRealm(XMLExtendedStreamReader reader, ServerConfigurationBuilder builder) throws XMLStreamException {
        ParseUtils.requireNoContent((XMLStreamReader)reader);
        return null;
    }

    private SecurityRealm parsePropertiesRealm(XMLExtendedStreamReader reader, String name) throws XMLStreamException {
        File usersFile = null;
        File groupsFile = null;
        boolean plainText = true;
        Element element = ServerConfigurationParser.nextElement((XMLStreamReader)reader);
        if (element == Element.USER_PROPERTIES) {
            usersFile = new File(ParseUtils.requireAttributes((XMLStreamReader)reader, (Enum[])new Enum[]{Attribute.PATH})[0]);
            ParseUtils.requireNoContent((XMLStreamReader)reader);
            element = ServerConfigurationParser.nextElement((XMLStreamReader)reader);
        }
        if (element == Element.GROUP_PROPERTIES) {
            groupsFile = new File(ParseUtils.requireAttributes((XMLStreamReader)reader, (Enum[])new Enum[]{Attribute.PATH})[0]);
            ParseUtils.requireNoContent((XMLStreamReader)reader);
            element = ServerConfigurationParser.nextElement((XMLStreamReader)reader);
        }
        if (element != null) {
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
        return new PropertiesSecurityRealm(usersFile, groupsFile, plainText, "Roles", name);
    }

    private void parseServerIdentitities(XMLExtendedStreamReader reader, ServerConfigurationBuilder builder) throws XMLStreamException {
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case SSL: {
                    this.parseSSL(reader, builder);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }

    private void parseSSL(XMLExtendedStreamReader reader, ServerConfigurationBuilder builder) throws XMLStreamException {
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ENGINE: {
                    this.parseSSLEngine(reader, builder);
                    continue block4;
                }
                case KEYSTORE: {
                    this.parseKeyStore(reader, builder);
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }

    private void parseSSLEngine(XMLExtendedStreamReader reader, ServerConfigurationBuilder builder) throws XMLStreamException {
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED_PROTOCOLS: {
                    continue block4;
                }
                case ENABLED_CIPHERSUITES: {
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    private void parseKeyStore(XMLExtendedStreamReader reader, ServerConfigurationBuilder builder) throws XMLStreamException {
        String[] attributes = ParseUtils.requireAttributes((XMLStreamReader)reader, (Enum[])new Enum[]{Attribute.PATH});
        String keyStoreFileName = attributes[0];
        String keyStorePassword = null;
        String keyStoreAlias = null;
        String keyStoreKeyPassword = null;
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case PATH: {
                    continue block8;
                }
                case RELATIVE_TO: {
                    continue block8;
                }
                case KEYSTORE_PASSWORD: {
                    keyStorePassword = value;
                    continue block8;
                }
                case ALIAS: {
                    keyStoreAlias = value;
                    continue block8;
                }
                case KEY_PASSWORD: {
                    keyStoreKeyPassword = value;
                    continue block8;
                }
                case GENERATE_SELF_SIGNED_CERTIFICATE_HOST: {
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    private void parseEndpoints(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        holder.pushScope(ENDPOINTS_SCOPE);
        while (reader.hasNext() && reader.nextTag() != 2) {
            reader.handleAny(holder);
        }
        holder.popScope();
    }
}

