package org.infinispan.server.logging;

import java.util.Locale;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.infinispan.commons.CacheConfigurationException;
import org.jboss.logging.BasicLogger;
import java.lang.String;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import org.jboss.logging.Logger;
import java.util.Arrays;
import java.lang.Exception;


import static org.jboss.logging.Logger.Level.INFO;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2019-08-02T16:46:31+0000")
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void serverStarting(final String name) {
        super.log.logf(FQCN, INFO, null, serverStarting$str(), name);
    }
    private static final String serverStarting = "ISPN080000: %s Server starting";
    protected String serverStarting$str() {
        return serverStarting;
    }
    @Override
    public final void serverStarted(final String name, final String version, final long ms) {
        super.log.logf(FQCN, INFO, null, serverStarted$str(), name, version, ms);
    }
    private static final String serverStarted = "ISPN080001: %s Server %s started in %dms";
    protected String serverStarted$str() {
        return serverStarted;
    }
    @Override
    public final void serverStopping(final String name) {
        super.log.logf(FQCN, INFO, null, serverStopping$str(), name);
    }
    private static final String serverStopping = "ISPN080002: %s Server stopping";
    protected String serverStopping$str() {
        return serverStopping;
    }
    @Override
    public final void serverStopped(final String name) {
        super.log.logf(FQCN, INFO, null, serverStopped$str(), name);
    }
    private static final String serverStopped = "ISPN080003: %s Server stopped";
    protected String serverStopped$str() {
        return serverStopped;
    }
    @Override
    public final void protocolStarted(final String name, final String host, final int port) {
        super.log.logf(FQCN, INFO, null, protocolStarted3$str(), name, host, port);
    }
    private static final String protocolStarted3 = "ISPN080004: Protocol %s listening on %s:%d";
    protected String protocolStarted3$str() {
        return protocolStarted3;
    }
    private static final String duplicatePath = "ISPN080005: Duplicate path '%s'";
    protected String duplicatePath$str() {
        return duplicatePath;
    }
    @Override
    public final CacheConfigurationException duplicatePath(final String name) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), duplicatePath$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String duplicateNetworkInterface = "ISPN080006: Duplicate network interface '%s'";
    protected String duplicateNetworkInterface$str() {
        return duplicateNetworkInterface;
    }
    @Override
    public final CacheConfigurationException duplicateNetworkInterface(final String name) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), duplicateNetworkInterface$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String duplicateSocketBinding = "ISPN080007: Duplicate socket binding '%s'";
    protected String duplicateSocketBinding$str() {
        return duplicateSocketBinding;
    }
    @Override
    public final CacheConfigurationException duplicateSocketBinding(final String name) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), duplicateSocketBinding$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotInstantiateProtocolServerConfigurationBuilder = "ISPN080008: Cannot instantiate protocol server configuration '%s'";
    protected String cannotInstantiateProtocolServerConfigurationBuilder$str() {
        return cannotInstantiateProtocolServerConfigurationBuilder;
    }
    @Override
    public final CacheConfigurationException cannotInstantiateProtocolServerConfigurationBuilder(final Class<?> klass, final Exception e) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), cannotInstantiateProtocolServerConfigurationBuilder$str(), klass), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownInterface = "ISPN080009: Unknown interface '%s'";
    protected String unknownInterface$str() {
        return unknownInterface;
    }
    @Override
    public final CacheConfigurationException unknownInterface(final String interfaceName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), unknownInterface$str(), interfaceName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownSocketBinding = "ISPN080010: Unknown socket binding '%s'";
    protected String unknownSocketBinding$str() {
        return unknownSocketBinding;
    }
    @Override
    public final CacheConfigurationException unknownSocketBinding(final String value) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), unknownSocketBinding$str(), value));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nonAbsolutePath = "ISPN080011: The path '%s' is not absolute";
    protected String nonAbsolutePath$str() {
        return nonAbsolutePath;
    }
    @Override
    public final CacheConfigurationException nonAbsolutePath(final String path) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), nonAbsolutePath$str(), path));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String duplicateSecurityRealm = "ISPN080012: Duplicate security domain '%s'";
    protected String duplicateSecurityRealm$str() {
        return duplicateSecurityRealm;
    }
    @Override
    public final CacheConfigurationException duplicateSecurityRealm(final String name) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), duplicateSecurityRealm$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String duplicateRealmType = "ISPN080013: Duplicate realm type '%s' in realm '%s'";
    protected String duplicateRealmType$str() {
        return duplicateRealmType;
    }
    @Override
    public final CacheConfigurationException duplicateRealmType(final String type, final String name) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), duplicateRealmType$str(), type, name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownSecurityDomain = "ISPN080014: Unknown security domain '%s'";
    protected String unknownSecurityDomain$str() {
        return unknownSecurityDomain;
    }
    @Override
    public final CacheConfigurationException unknownSecurityDomain(final String name) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), unknownSecurityDomain$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToLoadRealmPropertyFiles = "ISPN080015: Unable to load realm property files";
    protected String unableToLoadRealmPropertyFiles$str() {
        return unableToLoadRealmPropertyFiles;
    }
    @Override
    public final CacheConfigurationException unableToLoadRealmPropertyFiles(final IOException e) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), unableToLoadRealmPropertyFiles$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noDefaultKeyManager = "ISPN080016: No default key manager available";
    protected String noDefaultKeyManager$str() {
        return noDefaultKeyManager;
    }
    @Override
    public final NoSuchAlgorithmException noDefaultKeyManager() {
        final NoSuchAlgorithmException result = new NoSuchAlgorithmException(String.format(getLoggingLocale(), noDefaultKeyManager$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void serverConfiguration(final String name) {
        super.log.logf(FQCN, INFO, null, serverConfiguration$str(), name);
    }
    private static final String serverConfiguration = "ISPN080017: Server configuration: %s";
    protected String serverConfiguration$str() {
        return serverConfiguration;
    }
    @Override
    public final void protocolStarted(final String name) {
        super.log.logf(FQCN, INFO, null, protocolStarted1$str(), name);
    }
    private static final String protocolStarted1 = "ISPN080018: Protocol %s (internal)";
    protected String protocolStarted1$str() {
        return protocolStarted1;
    }
    @Override
    public final void routerStarted(final String host, final int port) {
        super.log.logf(FQCN, INFO, null, routerStarted$str(), host, port);
    }
    private static final String routerStarted = "ISPN080019: Protocol Router listening on %s:%d";
    protected String routerStarted$str() {
        return routerStarted;
    }
}
