/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.functional;

import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.server.functional.ClusteredIT;
import org.infinispan.server.security.Common;
import org.infinispan.server.test.InfinispanServerRule;
import org.infinispan.server.test.InfinispanServerTestMethodRule;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class RestOperations {
    @ClassRule
    public static InfinispanServerRule SERVERS = ClusteredIT.SERVERS;
    @Rule
    public InfinispanServerTestMethodRule SERVER_TEST = new InfinispanServerTestMethodRule(SERVERS);

    @Test
    public void testRestOperations() {
        RestClient client = this.SERVER_TEST.getRestClient(CacheMode.DIST_SYNC);
        String cache = this.SERVER_TEST.getMethodName();
        RestResponse response = (RestResponse)Common.sync(client.put(cache, "k1", "v1"));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        response = (RestResponse)Common.sync(client.get(cache, "k1"));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"v1", (Object)response.getBody());
        response = (RestResponse)Common.sync(client.delete(cache, "k1"));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        response = (RestResponse)Common.sync(client.get(cache, "k1"));
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }
}

