/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.security;

import javax.net.ssl.SSLHandshakeException;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.exceptions.TransportException;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.server.test.InfinispanServerRule;
import org.infinispan.server.test.InfinispanServerTestConfiguration;
import org.infinispan.server.test.InfinispanServerTestMethodRule;
import org.infinispan.server.test.category.Security;
import org.infinispan.test.Exceptions;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={Security.class})
public class AuthenticationCertIT {
    @ClassRule
    public static InfinispanServerRule SERVERS = new InfinispanServerRule(new InfinispanServerTestConfiguration("configuration/AuthenticationServerTrustTest.xml"));
    @Rule
    public InfinispanServerTestMethodRule SERVER_TEST = new InfinispanServerTestMethodRule(SERVERS);

    @Test
    public void testTrustedCertificate() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.security().ssl().trustStoreFileName(SERVERS.getServerDriver().getCertificateFile("ca").getAbsolutePath()).trustStorePassword("secret".toCharArray()).keyStoreFileName(SERVERS.getServerDriver().getCertificateFile("admin").getAbsolutePath()).keyStorePassword("secret".toCharArray()).authentication().saslMechanism("EXTERNAL").serverName("infinispan").realm("default");
        RemoteCache cache = this.SERVER_TEST.getHotRodCache(builder, CacheMode.DIST_SYNC);
        cache.put((Object)"k1", (Object)"v1");
        Assert.assertEquals((long)1L, (long)cache.size());
        Assert.assertEquals((Object)"v1", (Object)cache.get((Object)"k1"));
    }

    @Test
    public void testUntrustedCertificate() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.security().ssl().trustStoreFileName(SERVERS.getServerDriver().getCertificateFile("ca").getAbsolutePath()).trustStorePassword("secret".toCharArray()).keyStoreFileName(SERVERS.getServerDriver().getCertificateFile("untrusted").getAbsolutePath()).keyStorePassword("secret".toCharArray()).authentication().saslMechanism("EXTERNAL").serverName("infinispan").realm("default");
        Exceptions.expectException(TransportException.class, SSLHandshakeException.class, () -> this.SERVER_TEST.getHotRodCache(builder, CacheMode.DIST_SYNC));
    }
}

