/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.security;

import javax.security.auth.callback.Callback;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.server.security.Common;
import org.infinispan.server.test.InfinispanServerRule;
import org.infinispan.server.test.InfinispanServerTestConfiguration;
import org.infinispan.server.test.InfinispanServerTestMethodRule;
import org.infinispan.server.test.KeyCloakServerRule;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.wildfly.security.auth.callback.CredentialCallback;
import org.wildfly.security.credential.BearerTokenCredential;
import org.wildfly.security.credential.Credential;

public class AuthenticationKeyCloakIT {
    @ClassRule
    public static InfinispanServerRule SERVERS = new InfinispanServerRule(new InfinispanServerTestConfiguration("configuration/AuthenticationKeyCloakTest.xml"));
    @ClassRule
    public static KeyCloakServerRule KEYCLOAK = new KeyCloakServerRule("keycloak/infinispan-keycloak-realm.json");
    @Rule
    public InfinispanServerTestMethodRule SERVER_TEST = new InfinispanServerTestMethodRule(SERVERS);

    @Test
    public void testHotRodReadWrite() {
        String token = KEYCLOAK.getAccessTokenForCredentials("infinispan", "infinispan-client", "8a43581d-62d7-47dc-9aa4-cd3af24b6083", "admin", "adminPassword");
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.security().authentication().saslMechanism("OAUTHBEARER").serverName("infinispan").callbackHandler(callbacks -> {
            for (Callback callback : callbacks) {
                if (!(callback instanceof CredentialCallback)) continue;
                CredentialCallback cc = (CredentialCallback)callback;
                cc.setCredential((Credential)new BearerTokenCredential(token));
            }
        }).realm("default");
        RemoteCache cache = this.SERVER_TEST.getHotRodCache(builder, CacheMode.DIST_SYNC);
        cache.put((Object)"k1", (Object)"v1");
        Assert.assertEquals((long)1L, (long)cache.size());
        Assert.assertEquals((Object)"v1", (Object)cache.get((Object)"k1"));
    }

    @Test
    public void testRestReadWrite() {
        String token = KEYCLOAK.getAccessTokenForCredentials("infinispan", "infinispan-client", "8a43581d-62d7-47dc-9aa4-cd3af24b6083", "admin", "adminPassword");
        RestClientConfigurationBuilder builder = new RestClientConfigurationBuilder();
        builder.security().authentication().mechanism("Bearer").username(token);
        RestClient client = this.SERVER_TEST.getRestClient(builder, CacheMode.DIST_SYNC);
        RestResponse response = (RestResponse)Common.sync(client.post(this.SERVER_TEST.getMethodName(), "k1", "v1"));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        response = (RestResponse)Common.sync(client.get(this.SERVER_TEST.getMethodName(), "k1"));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"v1", (Object)response.getBody());
    }
}

