/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.security;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.test.Exceptions;

public class Common {
    public static final Map<String, User> USER_MAP = new HashMap<String, User>();
    public static final Collection<Object[]> SASL_MECHS;
    public static final Collection<Object[]> HTTP_MECHS;

    public static <T> T sync(CompletionStage<T> stage) {
        return (T)Exceptions.unchecked(() -> stage.toCompletableFuture().get(5L, TimeUnit.SECONDS));
    }

    static {
        USER_MAP.put("admin", new User("admin", "adminPassword", AuthorizationPermission.ALL.name()));
        USER_MAP.put("supervisor", new User("supervisorPassword", AuthorizationPermission.ALL_READ.name(), AuthorizationPermission.ALL_WRITE.name()));
        USER_MAP.put("reader", new User("reader", "readerPassword", AuthorizationPermission.ALL_READ.name()));
        USER_MAP.put("writer", new User("writer", "writerPassword", AuthorizationPermission.ALL_WRITE.name()));
        USER_MAP.put("unprivileged", new User("unprivileged", "unprivilegedPassword", AuthorizationPermission.NONE.name()));
        USER_MAP.put("executor", new User("executor", "executorPassword", AuthorizationPermission.EXEC.name()));
        SASL_MECHS = new ArrayList<Object[]>();
        SASL_MECHS.add(new Object[]{""});
        SASL_MECHS.add(new Object[]{"PLAIN"});
        SASL_MECHS.add(new Object[]{"DIGEST-MD5"});
        SASL_MECHS.add(new Object[]{"DIGEST-SHA-512"});
        SASL_MECHS.add(new Object[]{"DIGEST-SHA-384"});
        SASL_MECHS.add(new Object[]{"DIGEST-SHA-256"});
        SASL_MECHS.add(new Object[]{"DIGEST-SHA"});
        SASL_MECHS.add(new Object[]{"SCRAM-SHA-512"});
        SASL_MECHS.add(new Object[]{"SCRAM-SHA-384"});
        SASL_MECHS.add(new Object[]{"SCRAM-SHA-256"});
        SASL_MECHS.add(new Object[]{"SCRAM-SHA-1"});
        HTTP_MECHS = new ArrayList<Object[]>();
        HTTP_MECHS.add(new Object[]{""});
        HTTP_MECHS.add(new Object[]{"BASIC"});
        HTTP_MECHS.add(new Object[]{"DIGEST"});
    }

    public static class User {
        final String username;
        final char[] password;
        final Iterable<String> groups;

        public User(String username, String password, String ... groups) {
            this.username = username;
            this.password = password.toCharArray();
            this.groups = Arrays.asList(groups);
        }
    }
}

