/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test;

import org.jboss.logging.BasicLogger;
import org.testcontainers.containers.output.BaseConsumer;
import org.testcontainers.containers.output.OutputFrame;

public class JBossLoggingConsumer
extends BaseConsumer<JBossLoggingConsumer> {
    private final BasicLogger logger;
    private String prefix = "";

    public JBossLoggingConsumer(BasicLogger logger) {
        this.logger = logger;
    }

    public JBossLoggingConsumer withPrefix(String prefix) {
        this.prefix = "[" + prefix + "] ";
        return this;
    }

    public void accept(OutputFrame outputFrame) {
        OutputFrame.OutputType outputType = outputFrame.getType();
        String utf8String = outputFrame.getUtf8String();
        utf8String = utf8String.replaceAll("((\\r?\\n)|(\\r))$", "");
        switch (outputType) {
            case STDOUT: 
            case STDERR: {
                System.out.printf("%s%s: %s\n", this.prefix, outputType, utf8String);
                this.logger.tracef("%s%s: %s", (Object)this.prefix, (Object)outputType, (Object)utf8String);
            }
            case END: {
                return;
            }
        }
        throw new IllegalArgumentException("Unexpected outputType " + outputType);
    }
}

