/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test;

import java.io.File;
import java.io.InputStream;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.ldif.LdifEntry;
import org.apache.directory.api.ldap.model.ldif.LdifReader;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.AnnotationUtils;
import org.apache.directory.server.core.annotations.ContextEntry;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.annotations.CreateIndex;
import org.apache.directory.server.core.annotations.CreatePartition;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.factory.DSAnnotationProcessor;
import org.apache.directory.server.factory.ServerAnnotationProcessor;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.protocol.shared.transport.TcpTransport;
import org.apache.directory.server.protocol.shared.transport.Transport;
import org.infinispan.commons.util.Util;
import org.infinispan.server.test.InfinispanServerRule;
import org.infinispan.test.Exceptions;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class LdapServerRule
implements TestRule {
    public static final int LDAP_PORT = 10389;
    public static final int LDAPS_PORT = 10636;
    public static final String DEFAULT_LDIF = "ldif/infinispan.ldif";
    private final String initLDIF;
    private final InfinispanServerRule infinispanServerRule;
    private DirectoryService directoryService;
    private LdapServer ldapServer;

    public LdapServerRule(InfinispanServerRule infinispanServerRule) {
        this(infinispanServerRule, DEFAULT_LDIF);
    }

    public LdapServerRule(InfinispanServerRule infinispanServerRule, String initLDIF) {
        this.infinispanServerRule = infinispanServerRule;
        this.initLDIF = initLDIF;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                LdapServerRule.this.before();
                try {
                    base.evaluate();
                }
                finally {
                    LdapServerRule.this.after();
                }
            }
        };
    }

    private void before() {
        Exceptions.unchecked(() -> this.createDs());
        Exceptions.unchecked(() -> this.createLdap());
        Exceptions.unchecked(() -> this.ldapServer.start());
    }

    private void after() {
        try {
            this.ldapServer.stop();
            this.directoryService.shutdown();
        }
        catch (Exception exception) {
        }
        finally {
            Util.recursiveFileRemove((File)this.directoryService.getInstanceLayout().getInstanceDirectory());
        }
    }

    @CreateDS(name="InfinispanDS", partitions={@CreatePartition(name="infinispan", suffix="dc=infinispan,dc=org", contextEntry=@ContextEntry(entryLdif="dn: dc=infinispan,dc=org\ndc: infinispan\nobjectClass: top\nobjectClass: domain\n\n"), indexes={@CreateIndex(attribute="objectClass"), @CreateIndex(attribute="dc"), @CreateIndex(attribute="ou")})})
    public void createDs() throws Exception {
        this.directoryService = DSAnnotationProcessor.getDirectoryService();
    }

    @CreateLdapServer(transports={@CreateTransport(protocol="LDAP", port=10389, address="0.0.0.0")})
    public void createLdap() throws Exception {
        SchemaManager schemaManager = this.directoryService.getSchemaManager();
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream(this.initLDIF);){
            for (LdifEntry ldifEntry : new LdifReader(is)) {
                this.directoryService.getAdminSession().add((Entry)new DefaultEntry(schemaManager, ldifEntry.getEntry()));
            }
        }
        CreateLdapServer createLdapServer = (CreateLdapServer)AnnotationUtils.getInstance(CreateLdapServer.class);
        this.ldapServer = ServerAnnotationProcessor.instantiateLdapServer((CreateLdapServer)createLdapServer, (DirectoryService)this.directoryService);
        this.ldapServer.setKeystoreFile(this.infinispanServerRule.getServerDriver().getCertificateFile("server").getAbsolutePath());
        this.ldapServer.setCertificatePassword("secret");
        TcpTransport ldaps = new TcpTransport(10636);
        ldaps.enableSSL(true);
        this.ldapServer.addTransports(new Transport[]{ldaps});
    }
}

