/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.unit.configuration;

import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import org.infinispan.commons.util.FileLookup;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.rest.configuration.RestServerConfiguration;
import org.infinispan.server.configuration.ServerConfiguration;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.hotrod.configuration.HotRodServerConfiguration;
import org.infinispan.server.memcached.configuration.MemcachedServerConfiguration;
import org.infinispan.server.network.NetworkAddress;
import org.infinispan.server.network.SocketBinding;
import org.infinispan.test.fwk.TestResourceTracker;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ServerConfigurationParserTest {
    @BeforeClass
    public static void before() {
        TestResourceTracker.testStarted((String)ServerConfigurationParserTest.class.getName());
    }

    @AfterClass
    public static void after() {
        TestResourceTracker.testFinished((String)ServerConfigurationParserTest.class.getName());
    }

    @Test
    public void testParser() throws IOException {
        FileLookup fileLookup = FileLookupFactory.newInstance();
        URL url = fileLookup.lookupFileLocation("configuration/" + this.getClass().getSimpleName() + ".xml", ServerConfigurationParserTest.class.getClassLoader());
        Properties properties = new Properties();
        properties.setProperty("infinispan.server.config.path", System.getProperty("build.directory") + "/test-classes/configuration");
        ParserRegistry registry = new ParserRegistry(this.getClass().getClassLoader(), false, properties);
        ConfigurationBuilderHolder holder = registry.parse(url);
        GlobalConfiguration global = holder.getGlobalConfigurationBuilder().build();
        ServerConfiguration server = (ServerConfiguration)global.module(ServerConfiguration.class);
        Assert.assertEquals((long)2L, (long)server.networkInterfaces().size());
        NetworkAddress defaultInterface = (NetworkAddress)server.networkInterfaces().get("default");
        Assert.assertNotNull((Object)defaultInterface);
        Assert.assertTrue((boolean)defaultInterface.getAddress().isLoopbackAddress());
        Assert.assertEquals((long)2L, (long)server.socketBindings().size());
        Assert.assertEquals((long)11222L, (long)((SocketBinding)server.socketBindings().get("default")).getPort());
        Assert.assertEquals((long)11221L, (long)((SocketBinding)server.socketBindings().get("memcached")).getPort());
        Assert.assertEquals((long)3L, (long)server.connectors().size());
        Assert.assertTrue((boolean)(server.connectors().get(0) instanceof HotRodServerConfiguration));
        Assert.assertTrue((boolean)(server.connectors().get(1) instanceof RestServerConfiguration));
        Assert.assertTrue((boolean)(server.connectors().get(2) instanceof MemcachedServerConfiguration));
        Assert.assertEquals((Object)((SocketBinding)server.socketBindings().get("default")).getAddress().getAddress().getHostAddress(), (Object)server.endpoint().host());
        Assert.assertEquals((long)((SocketBinding)server.socketBindings().get("default")).getPort(), (long)server.endpoint().port());
        Assert.assertEquals((long)((SocketBinding)server.socketBindings().get("memcached")).getPort(), (long)((ProtocolServerConfiguration)server.connectors().get(2)).port());
    }
}

