/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.server.Server;
import org.infinispan.server.configuration.ServerConfiguration;
import org.infinispan.server.configuration.endpoint.SinglePortServerConfigurationBuilder;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.configuration.ProtocolServerConfigurationBuilder;
import org.infinispan.server.network.NetworkAddress;
import org.infinispan.server.network.SocketBinding;
import org.infinispan.server.security.ServerSecurityRealm;

public class ServerConfigurationBuilder
implements Builder<ServerConfiguration> {
    private final Map<String, NetworkAddress> networkInterfaces = new HashMap<String, NetworkAddress>(2);
    private final Map<String, ServerSecurityRealm> securityRealms = new HashMap<String, ServerSecurityRealm>(2);
    private final Map<String, SSLContext> sslContexts = new HashMap<String, SSLContext>(2);
    private final Map<String, SocketBinding> socketBindings = new HashMap<String, SocketBinding>(2);
    private final List<ProtocolServerConfigurationBuilder<?, ?>> connectors = new ArrayList(2);
    private final GlobalConfigurationBuilder builder;
    private final SinglePortServerConfigurationBuilder endpoint = new SinglePortServerConfigurationBuilder();

    public ServerConfigurationBuilder(GlobalConfigurationBuilder builder) {
        this.builder = builder;
    }

    public <T extends ProtocolServerConfigurationBuilder<?, ?>> T addConnector(Class<T> klass) {
        try {
            ProtocolServerConfigurationBuilder builder = (ProtocolServerConfigurationBuilder)klass.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.connectors.add(builder);
            this.endpoint.applyConfigurationToProtocol(builder);
            return (T)builder;
        }
        catch (Exception e) {
            throw Server.log.cannotInstantiateProtocolServerConfigurationBuilder(klass, e);
        }
    }

    public List<ProtocolServerConfigurationBuilder<?, ?>> connectors() {
        return this.connectors;
    }

    public SinglePortServerConfigurationBuilder endpoint() {
        return this.endpoint;
    }

    public void addSecurityRealm(String name, ServerSecurityRealm domain) {
        if (this.securityRealms.putIfAbsent(name, domain) != null) {
            throw Server.log.duplicateSecurityRealm(name);
        }
    }

    public void addSSLContext(String name, SSLContext sslContext) {
        if (this.sslContexts.putIfAbsent(name, sslContext) != null) {
            throw Server.log.duplicateSecurityRealm(name);
        }
    }

    public void addNetworkInterface(NetworkAddress networkAddress) {
        if (this.networkInterfaces.putIfAbsent(networkAddress.getName(), networkAddress) != null) {
            throw Server.log.duplicatePath(networkAddress.getName());
        }
    }

    public void addSocketBinding(String name, NetworkAddress networkAddress, int port) {
        if (this.socketBindings.putIfAbsent(name, new SocketBinding(name, networkAddress, port)) != null) {
            throw Server.log.duplicatePath(name);
        }
    }

    public void addSocketBinding(String name, String interfaceName, int port) {
        if (!this.networkInterfaces.containsKey(interfaceName)) {
            throw Server.log.unknownInterface(interfaceName);
        }
        this.addSocketBinding(name, this.networkInterfaces.get(interfaceName), port);
    }

    public void validate() {
    }

    public ServerConfiguration create() {
        return new ServerConfiguration(this.networkInterfaces, this.socketBindings, this.securityRealms, this.connectors.stream().map(b -> (ProtocolServerConfiguration)b.create()).collect(Collectors.toList()), this.endpoint.create());
    }

    public Builder<?> read(ServerConfiguration template) {
        return this;
    }

    public SocketBinding getSocketBinding(String name) {
        if (this.socketBindings.containsKey(name)) {
            return this.socketBindings.get(name);
        }
        throw Server.log.unknownSocketBinding(name);
    }

    public ServerSecurityRealm getSecurityRealm(String name) {
        if (this.securityRealms.containsKey(name)) {
            return this.securityRealms.get(name);
        }
        throw Server.log.unknownSecurityDomain(name);
    }

    public SSLContext getSSLContext(String name) {
        if (this.sslContexts.containsKey(name)) {
            return this.sslContexts.get(name);
        }
        throw Server.log.unknownSecurityDomain(name);
    }

    public void applySocketBinding(String name, ProtocolServerConfigurationBuilder builder) {
        SocketBinding socketBinding = this.socketBindings.get(name);
        if (socketBinding == null) {
            throw Server.log.unknownSocketBinding(name);
        }
        builder.host(socketBinding.getAddress().getAddress().getHostAddress()).port(socketBinding.getPort());
    }
}

