/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URL;
import java.util.Iterator;
import java.util.Properties;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.JsonWriter;
import org.infinispan.commons.util.FileLookup;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.server.configuration.ServerConfiguration;
import org.junit.Assert;
import org.junit.Test;

public class JsonSerializationTest {
    private FileLookup fileLookup = FileLookupFactory.newInstance();
    private ObjectMapper objectMapper = new ObjectMapper();
    private Properties properties = new Properties();

    private ServerConfiguration parse() throws Exception {
        this.properties.setProperty("infinispan.server.config.path", System.getProperty("build.directory") + "/test-classes/configuration");
        this.properties.setProperty("test-path", "/path");
        URL url = this.fileLookup.lookupFileLocation("configuration/ServerConfigurationParserTest.xml", JsonSerializationTest.class.getClassLoader());
        ParserRegistry registry = new ParserRegistry(this.getClass().getClassLoader(), false, this.properties);
        ConfigurationBuilderHolder holder = registry.parse(url);
        GlobalConfiguration global = holder.getGlobalConfigurationBuilder().build();
        return (ServerConfiguration)global.module(ServerConfiguration.class);
    }

    @Test
    public void testJsonSerialization() throws Exception {
        ServerConfiguration serverConfiguration = this.parse();
        JsonWriter writer = new JsonWriter();
        String json = writer.toJSON((ConfigurationInfo)serverConfiguration);
        JsonNode serverNode = this.objectMapper.readTree(json).get("server");
        JsonNode interfaces = serverNode.get("interfaces").get("interface");
        Assert.assertEquals((long)2L, (long)interfaces.size());
        JsonNode interface1 = interfaces.get(0);
        JsonNode interface2 = interfaces.get(1);
        JsonNode address1 = interface1.get("loopback");
        JsonNode address2 = interface2.get("loopback");
        Assert.assertEquals((Object)"default", (Object)interface1.get("name").asText());
        Assert.assertEquals((long)0L, (long)address1.size());
        Assert.assertEquals((Object)"another", (Object)interface2.get("name").asText());
        Assert.assertEquals((long)0L, (long)address2.size());
        JsonNode socketBindings = serverNode.get("socket-bindings");
        Assert.assertEquals((Object)"default", (Object)socketBindings.get("default-interface").asText());
        Assert.assertEquals((long)0L, (long)socketBindings.get("port-offset").asInt());
        JsonNode socketBinding = socketBindings.get("socket-binding");
        Assert.assertEquals((long)2L, (long)socketBinding.size());
        Iterator bindings = socketBinding.elements();
        JsonNode binding1 = (JsonNode)bindings.next();
        Assert.assertEquals((Object)"default", (Object)binding1.get("name").asText());
        Assert.assertEquals((long)11222L, (long)binding1.get("port").asInt());
        JsonNode binding2 = (JsonNode)bindings.next();
        Assert.assertEquals((Object)"memcached", (Object)binding2.get("name").asText());
        Assert.assertEquals((long)11221L, (long)binding2.get("port").asInt());
        JsonNode securityRealms = serverNode.get("security").get("security-realms");
        Assert.assertEquals((long)1L, (long)securityRealms.size());
        JsonNode securityRealm = securityRealms.get("security-realm");
        Assert.assertEquals((Object)"default", (Object)securityRealm.get("name").asText());
        JsonNode ssl = securityRealm.get("server-identities").get("ssl");
        JsonNode keyStore = ssl.get("keystore");
        Assert.assertEquals((Object)"ServerConfigurationParserTest-keystore.pfx", (Object)keyStore.get("path").asText());
        Assert.assertEquals((Object)this.properties.getProperty("infinispan.server.config.path"), (Object)keyStore.get("relative-to").asText());
        Assert.assertEquals((Object)"***", (Object)keyStore.get("keystore-password").asText());
        Assert.assertEquals((Object)"server", (Object)keyStore.get("alias").asText());
        Assert.assertEquals((Object)"***", (Object)keyStore.get("key-password").asText());
        Assert.assertEquals((Object)"localhost", (Object)keyStore.get("generate-self-signed-certificate-host").asText());
        JsonNode engine = ssl.get("engine");
        JsonNode protocols = engine.get("enabled-protocols");
        Iterator protocolItems = protocols.elements();
        Assert.assertEquals((Object)"TLSV1.1", (Object)((JsonNode)protocolItems.next()).asText());
        Assert.assertEquals((Object)"TLSV1.2", (Object)((JsonNode)protocolItems.next()).asText());
        Assert.assertEquals((Object)"TLSV1.3", (Object)((JsonNode)protocolItems.next()).asText());
        JsonNode cipherSuites = engine.get("enabled-ciphersuites");
        Assert.assertEquals((Object)"DHE-RSA-AES256-GCM-SHA384:DHE-RSA-AES128-GCM-SHA256", (Object)cipherSuites.asText());
        JsonNode filesystemRealm = securityRealm.get("filesystem-realm");
        Assert.assertEquals((Object)"security", (Object)filesystemRealm.get("path").asText());
        Assert.assertEquals((long)3L, (long)filesystemRealm.get("levels").asInt());
        Assert.assertFalse((boolean)filesystemRealm.get("encoded").asBoolean());
        Assert.assertEquals((Object)this.properties.getProperty("infinispan.server.config.path"), (Object)filesystemRealm.get("relative-to").asText());
        JsonNode ldapRealm = securityRealm.get("ldap-realm");
        Assert.assertEquals((Object)"ldap", (Object)ldapRealm.get("name").asText());
        Assert.assertEquals((Object)"ldap://${org.infinispan.test.host.address}:10389", (Object)ldapRealm.get("url").asText());
        Assert.assertEquals((Object)"uid=admin,ou=People,dc=infinispan,dc=org", (Object)ldapRealm.get("principal").asText());
        Assert.assertEquals((Object)"***", (Object)ldapRealm.get("credential").asText());
        JsonNode ldapIdentityMapping = ldapRealm.get("identity-mapping");
        Assert.assertEquals((Object)"uid", (Object)ldapIdentityMapping.get("rdn-identifier").asText());
        Assert.assertEquals((Object)"ou=People,dc=infinispan,dc=org", (Object)ldapIdentityMapping.get("search-base-dn").asText());
        JsonNode attributeMapping = ldapIdentityMapping.get("attribute-mapping");
        JsonNode attributes = attributeMapping.get("attribute");
        Assert.assertEquals((long)2L, (long)attributes.size());
        Iterator elements = attributes.elements();
        JsonNode attribute1 = (JsonNode)elements.next();
        Assert.assertEquals((Object)"cn", (Object)attribute1.get("from").asText());
        Assert.assertEquals((Object)"Roles", (Object)attribute1.get("to").asText());
        Assert.assertEquals((Object)"(&(objectClass=groupOfNames)(member={1}))", (Object)attribute1.get("filter").asText());
        Assert.assertEquals((Object)"ou=Roles,dc=infinispan,dc=org", (Object)attribute1.get("filter-dn").asText());
        JsonNode attribute2 = (JsonNode)elements.next();
        Assert.assertEquals((Object)"cn2", (Object)attribute2.get("from").asText());
        Assert.assertEquals((Object)"Roles2", (Object)attribute2.get("to").asText());
        Assert.assertEquals((Object)"(&(objectClass=GroupOfUniqueNames)(member={0}))", (Object)attribute2.get("filter").asText());
        Assert.assertEquals((Object)"ou=People,dc=infinispan,dc=org", (Object)attribute2.get("filter-dn").asText());
        JsonNode userPasswordMapping = ldapIdentityMapping.get("user-password-mapper");
        Assert.assertEquals((Object)"userPassword", (Object)userPasswordMapping.get("from").asText());
        Assert.assertFalse((boolean)userPasswordMapping.get("verifiable").asBoolean());
        Assert.assertFalse((boolean)userPasswordMapping.get("writable").asBoolean());
        JsonNode localRealm = securityRealm.get("local-realm");
        Assert.assertEquals((Object)"test-local", (Object)localRealm.get("name").asText());
        JsonNode kerberosRealm = securityRealm.get("kerberos-realm");
        Assert.assertEquals((Object)"keytab", (Object)kerberosRealm.get("keytab-path").asText());
        Assert.assertEquals((Object)this.properties.getProperty("infinispan.server.config.path"), (Object)kerberosRealm.get("relative-to").asText());
        JsonNode propertiesRealm = securityRealm.get("properties-realm");
        Assert.assertEquals((Object)"Roles", (Object)propertiesRealm.get("groups-attribute").asText());
        JsonNode userProperties = propertiesRealm.get("user-properties");
        Assert.assertEquals((Object)"ServerConfigurationParserTest-user.properties", (Object)userProperties.get("path").asText());
        Assert.assertEquals((Object)"digest", (Object)userProperties.get("digest-realm-name").asText());
        Assert.assertEquals((Object)this.properties.getProperty("infinispan.server.config.path"), (Object)userProperties.get("relative-to").asText());
        Assert.assertTrue((boolean)userProperties.get("plain-text").asBoolean());
        JsonNode groupProperties = propertiesRealm.get("group-properties");
        Assert.assertEquals((Object)this.properties.getProperty("infinispan.server.config.path"), (Object)groupProperties.get("relative-to").asText());
        Assert.assertEquals((Object)"ServerConfigurationParserTest-group.properties", (Object)groupProperties.get("path").asText());
        JsonNode tokenRealm = securityRealm.get("token-realm");
        Assert.assertEquals((Object)"token-test", (Object)tokenRealm.get("name").asText());
        Assert.assertEquals((Object)"username-claim", (Object)tokenRealm.get("principal-claim").asText());
        JsonNode oath = tokenRealm.get("oauth2-introspection");
        Assert.assertEquals((Object)"ANY", (Object)oath.get("host-name-verification-policy").asText());
        Assert.assertEquals((Object)"http://${org.infinispan.test.host .address}:14567/auth/realms/infinispan/protocol/openid-connect/token/introspect", (Object)oath.get("introspection-url").asText());
        Assert.assertEquals((Object)"infinispan-server", (Object)oath.get("client-id").asText());
        Assert.assertEquals((Object)"***", (Object)oath.get("client-secret").asText());
        JsonNode trustStoreRealm = securityRealm.get("truststore-realm");
        Assert.assertEquals((Object)"truststore.p12", (Object)trustStoreRealm.get("path").asText());
        Assert.assertEquals((Object)"SunJSSE", (Object)trustStoreRealm.get("provider").asText());
        Assert.assertEquals((Object)this.properties.getProperty("infinispan.server.config.path"), (Object)trustStoreRealm.get("relative-to").asText());
        Assert.assertEquals((Object)"***", (Object)trustStoreRealm.get("keystore-password").asText());
    }
}

