/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.functional;

import java.io.IOException;
import java.util.List;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.marshall.MarshallerUtil;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.ProtoStreamMarshaller;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoSchemaBuilder;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.server.functional.ClusteredIT;
import org.infinispan.server.test.InfinispanServerRule;
import org.infinispan.server.test.InfinispanServerTestMethodRule;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class HotRodCacheQueries {
    @ClassRule
    public static InfinispanServerRule SERVERS = ClusteredIT.SERVERS;
    @Rule
    public InfinispanServerTestMethodRule SERVER_TEST = new InfinispanServerTestMethodRule(SERVERS);

    @Test
    public void testQueries() throws IOException {
        ConfigurationBuilder config = new ConfigurationBuilder();
        config.marshaller((Marshaller)new ProtoStreamMarshaller());
        RemoteCache cache = this.SERVER_TEST.getHotRodCache(config, CacheMode.DIST_SYNC);
        RemoteCacheManager rcm = cache.getRemoteCacheManager();
        SerializationContext serializationContext = MarshallerUtil.getSerializationContext((RemoteCacheManager)rcm);
        ProtoSchemaBuilder protoSchemaBuilder = new ProtoSchemaBuilder();
        String protoFile = protoSchemaBuilder.fileName("test.proto").addClass(Person.class).build(serializationContext);
        RemoteCache metadataCache = rcm.getCache("___protobuf_metadata");
        metadataCache.put((Object)"test.proto", (Object)protoFile);
        Assert.assertFalse((boolean)metadataCache.containsKey((Object)".errors"));
        cache.clear();
        cache.put((Object)"Adrian", (Object)new Person("Adrian", 1));
        Assert.assertTrue((boolean)cache.containsKey((Object)"Adrian"));
        QueryFactory qf = Search.getQueryFactory(cache);
        Query query = qf.from(Person.class).having("name").eq((Object)"Adrian").build();
        List list = query.list();
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals(Person.class, ((Person)list.get(0)).getClass());
        Assert.assertEquals((Object)"Adrian", (Object)((Person)list.get((int)0)).name);
    }

    public static class Person {
        @ProtoField(number=1)
        public String name;
        @ProtoField(number=2)
        public Integer id;

        public Person() {
        }

        public Person(String name, Integer id) {
            this.name = name;
            this.id = id;
        }
    }
}

