/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.security.authentication;

import java.util.Collection;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.commons.test.ThreadLeakChecker;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.server.security.Common;
import org.infinispan.server.security.authentication.AuthenticationIT;
import org.infinispan.server.test.InfinispanServerRule;
import org.infinispan.server.test.InfinispanServerTestMethodRule;
import org.infinispan.server.test.category.Security;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={Security.class})
public class RestAuthentication {
    @ClassRule
    public static InfinispanServerRule SERVERS = AuthenticationIT.SERVERS;
    @Rule
    public InfinispanServerTestMethodRule SERVER_TEST = new InfinispanServerTestMethodRule(SERVERS);
    private final String mechanism;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Common.HTTP_MECHS;
    }

    public RestAuthentication(String mechanism) {
        this.mechanism = mechanism;
    }

    @Test
    public void testRestReadWrite() {
        RestClientConfigurationBuilder builder = new RestClientConfigurationBuilder();
        if (!this.mechanism.isEmpty()) {
            builder.security().authentication().mechanism(this.mechanism).realm("default").username("all_user").password("all");
        }
        RestClient client = this.SERVER_TEST.getRestClient(builder, CacheMode.DIST_SYNC);
        RestResponse response = (RestResponse)Common.sync(client.post(this.SERVER_TEST.getMethodName(), "k1", "v1"));
        if (this.mechanism.isEmpty()) {
            Assert.assertEquals((long)401L, (long)response.getStatus());
        } else {
            Assert.assertEquals((long)200L, (long)response.getStatus());
            response = (RestResponse)Common.sync(client.get(this.SERVER_TEST.getMethodName(), "k1"));
            Assert.assertEquals((long)200L, (long)response.getStatus());
            Assert.assertEquals((Object)"v1", (Object)response.getBody());
        }
    }

    @AfterClass
    public static void afterClass() {
        ThreadLeakChecker.ignoreThreadsContaining((String)"pool-.*");
    }
}

