/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test;

import java.io.File;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.management.MBeanServerConnection;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.server.DefaultExitHandler;
import org.infinispan.server.ExitHandler;
import org.infinispan.server.Server;
import org.infinispan.server.test.InfinispanServerDriver;
import org.infinispan.server.test.InfinispanServerTestConfiguration;
import org.infinispan.test.TestingUtil;

public class EmbeddedInfinispanServerDriver
extends InfinispanServerDriver {
    public static final int OFFSET_FACTOR = 100;
    List<Server> servers;
    List<CompletableFuture<Integer>> serverFutures;

    protected EmbeddedInfinispanServerDriver(InfinispanServerTestConfiguration configuration) {
        super(configuration, InetAddress.getLoopbackAddress());
    }

    @Override
    protected void start(String name, File rootDir, String configurationFile) {
        this.servers = new ArrayList<Server>();
        this.serverFutures = new ArrayList<CompletableFuture<Integer>>();
        for (int i = 0; i < this.configuration.numServers(); ++i) {
            File serverRoot = EmbeddedInfinispanServerDriver.createServerHierarchy(rootDir, Integer.toString(i));
            Properties properties = new Properties();
            properties.setProperty("infinispan.server.config.path", new File(rootDir, "conf").getAbsolutePath());
            properties.setProperty("infinispan.socket.binding.port-offset", Integer.toString(i * 100));
            properties.setProperty("infinispan.cluster.name", name);
            properties.setProperty("org.infinispan.test.host.address", this.testHostAddress.getHostName());
            Server server2 = new Server(serverRoot, new File(configurationFile), properties);
            server2.setExitHandler((ExitHandler)new DefaultExitHandler());
            this.serverFutures.add(server2.run());
            this.servers.add(server2);
        }
        List<CacheContainer> cacheManagers = this.servers.stream().map(server -> (DefaultCacheManager)server.getCacheManagers().values().iterator().next()).collect(Collectors.toList());
        TestingUtil.blockUntilViewsReceived((long)30000L, (CacheContainer[])cacheManagers.toArray(new CacheContainer[0]));
    }

    @Override
    protected void stop() {
        RuntimeException aggregate = new RuntimeException();
        for (int i = 0; i < this.servers.size(); ++i) {
            Server server = this.servers.get(i);
            server.getExitHandler().exit(0);
            try {
                this.serverFutures.get(i).get();
                continue;
            }
            catch (Throwable t) {
                aggregate.addSuppressed(t);
            }
        }
        if (aggregate.getSuppressed().length > 0) {
            throw aggregate;
        }
    }

    @Override
    public InetSocketAddress getServerAddress(int server, int port) {
        return new InetSocketAddress("localhost", port + server * 100);
    }

    @Override
    public void pause(int server) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void resume(int server) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void stop(int server) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void kill(int server) {
        throw new UnsupportedOperationException();
    }

    @Override
    public MBeanServerConnection getJmxConnection(int server) {
        DefaultCacheManager cacheManager = (DefaultCacheManager)this.servers.get(server).getCacheManagers().values().iterator().next();
        return cacheManager.getCacheManagerConfiguration().globalJmxStatistics().mbeanServerLookup().getMBeanServer();
    }
}

