/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test;

import org.infinispan.server.test.ContainerInfinispanServerDriver;
import org.infinispan.server.test.EmbeddedInfinispanServerDriver;
import org.infinispan.server.test.InfinispanServerDriver;
import org.infinispan.server.test.InfinispanServerTestConfiguration;

public enum ServerRunMode {
    EMBEDDED{

        @Override
        InfinispanServerDriver newDriver(InfinispanServerTestConfiguration configuration) {
            return new EmbeddedInfinispanServerDriver(configuration);
        }
    }
    ,
    CONTAINER{

        @Override
        InfinispanServerDriver newDriver(InfinispanServerTestConfiguration configuration) {
            return new ContainerInfinispanServerDriver(configuration);
        }
    }
    ,
    DEFAULT{

        @Override
        InfinispanServerDriver newDriver(InfinispanServerTestConfiguration configuration) {
            String driverName = System.getProperty("org.infinispan.test.server.driver", EMBEDDED.name());
            ServerRunMode driver = ServerRunMode.valueOf(driverName);
            return driver.newDriver(configuration);
        }
    };


    abstract InfinispanServerDriver newDriver(InfinispanServerTestConfiguration var1);
}

